/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.PessimisticLockException;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MyISAMStorageEngine;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.FieldFunction;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.MySQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.MySQLUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.CastType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.NullOrdering;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class MySQLDialect
extends Dialect {
    private final UniqueDelegate uniqueDelegate;
    private final MySQLStorageEngine storageEngine;
    private final int version;
    private final int characterSetBytesPerCharacter;
    private final Dialect.SizeStrategy sizeStrategy;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (Integer.parseInt(JdbcExceptionHelper.extractSqlState(sqle))) {
            case 23000: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" for key '", "'", sqle.getMessage());
            }
        }
        return null;
    });

    public MySQLDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10, MySQLDialect.getCharacterSetBytesPerCharacter(info.unwrap(DatabaseMetaData.class)));
        this.registerKeywords(info);
    }

    public MySQLDialect() {
        this(500);
    }

    public MySQLDialect(int version) {
        this(version, 4);
    }

    public MySQLDialect(int version, int characterSetBytesPerCharacter) {
        this.version = version;
        this.characterSetBytesPerCharacter = characterSetBytesPerCharacter;
        String storageEngine = Environment.getProperties().getProperty("hibernate.dialect.storage_engine");
        if (storageEngine == null) {
            storageEngine = System.getProperty("hibernate.dialect.storage_engine");
        }
        if (storageEngine == null) {
            this.storageEngine = this.getDefaultMySQLStorageEngine();
        } else if ("innodb".equalsIgnoreCase(storageEngine)) {
            this.storageEngine = InnoDBStorageEngine.INSTANCE;
        } else if ("myisam".equalsIgnoreCase(storageEngine)) {
            this.storageEngine = MyISAMStorageEngine.INSTANCE;
        } else {
            throw new UnsupportedOperationException("The " + storageEngine + " storage engine is not supported!");
        }
        this.registerColumnType(16, "bit");
        this.registerColumnType(2, "decimal($p,$s)");
        if (this.getMySQLVersion() < 570) {
            this.registerColumnType(93, "datetime");
            this.registerColumnType(2014, "timestamp");
        } else {
            this.registerColumnType(93, "datetime($p)");
            this.registerColumnType(2014, "timestamp($p)");
        }
        int maxVarcharLen = this.getMaxVarcharLen();
        this.registerColumnType(12, maxVarcharLen, "varchar($l)");
        this.registerColumnType(-3, maxVarcharLen, "varbinary($l)");
        int maxTinyLobLen = 255;
        int maxLobLen = 65535;
        int maxMediumLobLen = 0xFFFFFF;
        long maxLongLobLen = 0xFFFFFFFFL;
        this.registerColumnType(12, 0xFFFFFFFFL, "longtext");
        this.registerColumnType(12, 0xFFFFFFL, "mediumtext");
        if (maxVarcharLen < 65535) {
            this.registerColumnType(12, 65535L, "text");
        }
        this.registerColumnType(-3, 0xFFFFFFFFL, "longblob");
        this.registerColumnType(-3, 0xFFFFFFL, "mediumblob");
        if (maxVarcharLen < 65535) {
            this.registerColumnType(-3, 65535L, "blob");
        }
        this.registerColumnType(2004, 0xFFFFFFFFL, "longblob");
        this.registerColumnType(2004, 0xFFFFFFL, "mediumblob");
        this.registerColumnType(2004, 65535L, "blob");
        this.registerColumnType(2004, 255L, "tinyblob");
        this.registerColumnType(2005, 0xFFFFFFFFL, "longtext");
        this.registerColumnType(2005, 0xFFFFFFL, "mediumtext");
        this.registerColumnType(2005, 65535L, "text");
        this.registerColumnType(2005, 255L, "tinytext");
        this.registerColumnType(2011, "longtext");
        this.registerColumnType(2011, 0xFFFFFFFFL, "longtext");
        this.registerColumnType(2011, 0xFFFFFFL, "mediumtext");
        this.registerColumnType(2011, 65535L, "text");
        this.registerColumnType(2011, 255L, "tinytext");
        if (this.getMySQLVersion() >= 570) {
            this.registerColumnType(3001, "json");
        }
        this.registerColumnType(3200, "geometry");
        this.registerKeyword("key");
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.uniqueDelegate = new MySQLUniqueDelegate(this);
        this.sizeStrategy = new Dialect.SizeStrategyImpl(){

            @Override
            public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
                switch (jdbcType.getDefaultSqlTypeCode()) {
                    case -7: {
                        if (length == null) break;
                        return Size.length(Math.min(Math.max(length, 1L), 64L));
                    }
                }
                return super.resolveSize(jdbcType, javaType, precision, scale, length);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int getCharacterSetBytesPerCharacter(DatabaseMetaData databaseMetaData) {
        if (databaseMetaData == null) return 4;
        try (Statement s = databaseMetaData.getConnection().createStatement();){
            ResultSet rs = s.executeQuery("SELECT @@character_set_database");
            if (!rs.next()) return 4;
            String characterSet = rs.getString(1);
            int collationIndex = characterSet.indexOf(95);
            switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                case "utf16": 
                case "utf16le": 
                case "utf32": 
                case "utf8mb4": 
                case "gb18030": {
                    int n = 4;
                    return n;
                }
                case "utf8": 
                case "utf8mb3": 
                case "eucjpms": 
                case "ujis": {
                    int n = 3;
                    return n;
                }
                case "ucs2": 
                case "cp932": 
                case "big5": 
                case "euckr": 
                case "gb2312": 
                case "gbk": 
                case "sjis": {
                    int n = 2;
                    return n;
                }
            }
            int n = 1;
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 4;
    }

    protected int getMaxVarcharLen() {
        if (this.getMySQLVersion() < 500) {
            return 255;
        }
        switch (this.characterSetBytesPerCharacter) {
            case 1: {
                return 65535;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 3: {
                return 21844;
            }
        }
        return 16383;
    }

    @Override
    public String getNullColumnString(String columnType) {
        if (columnType.regionMatches(true, 0, "timestamp", 0, "timestamp".length())) {
            return " null";
        }
        return super.getNullColumnString(columnType);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int getMySQLVersion() {
        return this.version;
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public long getDefaultLobLength() {
        return 0xFFFFFFL;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.log2(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.pad_space(queryEngine);
        CommonFunctionFactory.md5(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.date(queryEngine);
        CommonFunctionFactory.timestamp(queryEngine);
        this.time(queryEngine);
        CommonFunctionFactory.utcDateTimeTimestamp(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.crc32(queryEngine);
        CommonFunctionFactory.sha1(queryEngine);
        CommonFunctionFactory.sha2(queryEngine);
        CommonFunctionFactory.sha(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.bitandorxornot_operator(queryEngine);
        CommonFunctionFactory.bitAndOr(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.datediff(queryEngine);
        CommonFunctionFactory.adddateSubdateAddtimeSubtime(queryEngine);
        CommonFunctionFactory.format_dateFormat(queryEngine);
        CommonFunctionFactory.makedateMaketime(queryEngine);
        if (this.getMySQLVersion() < 570) {
            CommonFunctionFactory.sysdateParens(queryEngine);
        } else {
            CommonFunctionFactory.sysdateExplicitMicros(queryEngine);
        }
        queryEngine.getSqmFunctionRegistry().register("field", new FieldFunction(queryEngine.getTypeConfiguration()));
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry();
        if (this.getMySQLVersion() >= 570) {
            jdbcTypeRegistry.addDescriptorIfAbsent(3001, JsonJdbcType.INSTANCE);
        }
        typeContributions.contributeJdbcTypeDescriptor(NullJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new MySQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.INTEGER_BOOLEAN) {
            switch (from) {
                case STRING: 
                case INTEGER: 
                case LONG: 
                case YN_BOOLEAN: 
                case TF_BOOLEAN: 
                case BOOLEAN: {
                    break;
                }
                default: {
                    return "abs(sign(?1))";
                }
            }
        }
        return super.castPattern(from, to);
    }

    private void time(QueryEngine queryEngine) {
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).register();
    }

    @Override
    public int getFloatPrecision() {
        return 23;
    }

    @Override
    public String currentTimestamp() {
        return this.getMySQLVersion() < 570 ? super.currentTimestamp() : "current_timestamp(6)";
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+microsecond(?2)/1e6)";
            }
            case WEEK: {
                return "weekofyear(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampadd(microsecond,(?2)/1e3,?3)";
            }
            case NATIVE: {
                return "timestampadd(microsecond,?2,?3)";
            }
        }
        return "timestampadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NANOSECOND: {
                return "timestampdiff(microsecond,?2,?3)*1e3";
            }
            case NATIVE: {
                return "timestampdiff(microsecond,?2,?3)";
            }
        }
        return "timestampdiff(?1,?2,?3)";
    }

    @Override
    public boolean supportsUnionAll() {
        return this.getMySQLVersion() >= 500;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return this.getMySQLVersion() < 500 ? super.getQueryHintString(query, hints) : IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return this.getMySQLVersion() < 500 ? super.getViolatedConstraintNameExtractor() : EXTRACTOR;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String cols = String.join((CharSequence)", ", foreignKey);
        String referencedCols = String.join((CharSequence)", ", primaryKey);
        return String.format(" add constraint %s foreign key (%s) references %s (%s)", constraintName, cols, referencedTable, referencedCols);
    }

    @Override
    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean canCreateCatalog() {
        return true;
    }

    @Override
    public String[] getCreateCatalogCommand(String catalogName) {
        return new String[]{"create database " + catalogName};
    }

    @Override
    public String[] getDropCatalogCommand(String catalogName) {
        return new String[]{"drop database " + catalogName};
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("MySQL does not support dropping creating/dropping schemas in the JDBC sense");
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid()";
    }

    @Override
    public String getTableComment(String comment) {
        return " comment='" + comment + "'";
    }

    @Override
    public String getColumnComment(String comment) {
        return " comment '" + comment + "'";
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), () -> new TempIdTableExporter(true, this::getTypeName){

            @Override
            protected String getCreateCommand() {
                return "create temporary table if not exists";
            }

            @Override
            protected String getDropCommand() {
                return "drop temporary table";
            }
        }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public String getCastTypeName(SqlExpressable type, Long length, Integer precision, Integer scale) {
        JdbcMapping jdbcMapping = type.getJdbcMapping();
        JdbcType jdbcType = jdbcMapping.getJdbcTypeDescriptor();
        JavaType javaType = jdbcMapping.getJavaTypeDescriptor();
        switch (jdbcType.getDefaultSqlTypeCode()) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "signed";
            }
            case -7: {
                return "unsigned";
            }
            case 6: 
            case 7: 
            case 8: {
                return String.format("decimal(%d, %d)", precision == null ? javaType.getDefaultSqlPrecision(this, jdbcType) : precision.intValue(), scale == null ? javaType.getDefaultSqlScale(this, jdbcType) : scale.intValue());
            }
            case -4: 
            case -3: {
                return String.format("binary(%d)", length != null ? length.longValue() : javaType.getDefaultSqlLength(this, jdbcType));
            }
            case -1: 
            case 12: {
                return String.format("char(%d)", length != null ? length.longValue() : javaType.getDefaultSqlLength(this, jdbcType));
            }
        }
        return super.getCastTypeName(type, length, precision, scale);
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (sqlException.getErrorCode()) {
                case 1205: 
                case 3572: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 1206: 
                case 1207: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
            }
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "41000": {
                        return new LockTimeoutException(message, sqlException, sql);
                    }
                    case "40001": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.CATALOG;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new MySQLIdentityColumnSupport();
    }

    @Override
    public boolean isJdbcLogWarningsEnabledByDefault() {
        return false;
    }

    @Override
    public boolean supportsCascadeDelete() {
        return this.storageEngine.supportsCascadeDelete();
    }

    @Override
    public String getTableTypeString() {
        String engineKeyword = this.getMySQLVersion() < 500 ? "type" : "engine";
        return this.storageEngine.getTableTypeString(engineKeyword);
    }

    @Override
    public boolean hasSelfReferentialForeignKeyBug() {
        return this.storageEngine.hasSelfReferentialForeignKeyBug();
    }

    @Override
    public boolean dropConstraints() {
        return this.storageEngine.dropConstraints();
    }

    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return this.getMySQLVersion() < 550 ? MyISAMStorageEngine.INSTANCE : InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (c) {
                case '\'': {
                    appender.appendSql('\'');
                    break;
                }
                case '\\': {
                    appender.appendSql('\\');
                }
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(MySQLDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "%Y").replace("MMMM", "%M").replace("MMM", "%b").replace("MM", "%m").replace("M", "%c").replace("ww", "%v").replace("w", "%v").replace("YYYY", "%x").replace("YYY", "%x").replace("YY", "%x").replace("Y", "%x").replace("EEEE", "%W").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%e").replace("DDD", "%j").replace("DD", "%j").replace("D", "%j").replace("aa", "%p").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%l").replace("H", "%k").replace("mm", "%i").replace("m", "%i").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%f").replace("SSSSS", "%f").replace("SSSS", "%f").replace("SSS", "%f").replace("SS", "%f").replace("S", "%f");
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
            case -1: {
                return lockString;
            }
        }
        return this.supportsWait() ? lockString + " wait " + timeout : lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(this.supportsForShare() ? " for share" : " lock in share mode", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        if (this.supportsAliasLocks() && this.supportsForShare()) {
            return this.withTimeout(" for share of " + aliases, timeout);
        }
        return this.getReadLockString(timeout);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " skip locked" : this.getForUpdateSkipLockedString();
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() && this.supportsAliasLocks() ? this.getForUpdateString(aliases) + " nowait" : this.getForUpdateNowaitString();
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.supportsAliasLocks() ? " for update of " + aliases : this.getForUpdateString();
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return this.getMySQLVersion() >= 802;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getMySQLVersion() >= 800;
    }

    @Override
    public boolean supportsNoWait() {
        return this.getMySQLVersion() >= 800;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.supportsAliasLocks() ? RowLockStrategy.TABLE : RowLockStrategy.NONE;
    }

    boolean supportsForShare() {
        return this.getMySQLVersion() >= 800;
    }

    boolean supportsAliasLocks() {
        return this.getMySQLVersion() >= 800;
    }
}

