/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleSqlAstTranslator;
import org.hibernate.dialect.OracleTypesHelper;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.NvlCoalesceEmulation;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.Oracle12cIdentityColumnSupport;
import org.hibernate.dialect.pagination.LegacyOracleLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.Oracle12LimitHandler;
import org.hibernate.dialect.sequence.OracleSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.CastType;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorOracleDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NullJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsNullTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class OracleDialect
extends Dialect {
    private static final Pattern DISTINCT_KEYWORD_PATTERN = Pattern.compile("\\bdistinct\\b");
    private static final Pattern GROUP_BY_KEYWORD_PATTERN = Pattern.compile("\\bgroup\\sby\\b");
    private static final Pattern ORDER_BY_KEYWORD_PATTERN = Pattern.compile("\\border\\sby\\b");
    private static final Pattern UNION_KEYWORD_PATTERN = Pattern.compile("\\bunion\\b");
    private static final Pattern SQL_STATEMENT_TYPE_PATTERN = Pattern.compile("^(?:/\\*.*?\\*/)?\\s*(select|insert|update|delete)\\s+.*?", 2);
    private static final int PARAM_LIST_SIZE_LIMIT = 1000;
    public static final String PREFER_LONG_RAW = "hibernate.dialect.oracle.prefer_long_raw";
    private final LimitHandler limitHandler;
    private final int version;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case 1: 
            case 2291: 
            case 2292: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("(", ")", sqle.getMessage());
            }
            case 1400: {
                return null;
            }
        }
        return null;
    });

    public OracleDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion());
        this.registerKeywords(info);
    }

    public OracleDialect() {
        this(800);
    }

    public OracleDialect(int version) {
        this.version = version;
        this.registerCharacterTypeMappings();
        this.registerNumericTypeMappings();
        this.registerDateTimeTypeMappings();
        this.registerBinaryTypeMappings();
        this.registerExtendedTypeMappings();
        this.registerReverseHibernateTypeMappings();
        this.registerDefaultProperties();
        this.limitHandler = this.supportsFetchClause(FetchClauseType.ROWS_ONLY) ? Oracle12LimitHandler.INSTANCE : new LegacyOracleLimitHandler(this.getVersion());
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.leftRight_substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.rownumRowid(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.systimestamp(queryEngine);
        CommonFunctionFactory.characterLength_length(queryEngine, SqlAstNodeRenderingMode.DEFAULT);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        CommonFunctionFactory.everyAny_sumCaseCase(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.covarPopSamp(queryEngine);
        CommonFunctionFactory.corr(queryEngine);
        CommonFunctionFactory.regrLinearRegressionAggregates(queryEngine);
        CommonFunctionFactory.bitLength_pattern(queryEngine, "vsize(?1)*8");
        if (this.getVersion() < 900) {
            queryEngine.getSqmFunctionRegistry().register("coalesce", new NvlCoalesceEmulation());
        } else {
            CommonFunctionFactory.coalesce(queryEngine);
        }
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", queryEngine.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new OracleSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String currentDate() {
        return this.getVersion() < 900 ? this.currentTimestamp() : "current_date";
    }

    @Override
    public String currentTime() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestamp() {
        return this.getVersion() < 900 ? "sysdate" : this.currentTimestampWithTimeZone();
    }

    @Override
    public String currentLocalTime() {
        return this.currentLocalTimestamp();
    }

    @Override
    public String currentLocalTimestamp() {
        return this.getVersion() < 900 ? this.currentTimestamp() : "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return this.getVersion() < 900 ? this.currentTimestamp() : "current_timestamp";
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger(from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result = BooleanDecoder.toIntegerBoolean(from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result = BooleanDecoder.toYesNoBoolean(from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: 
            case BOOLEAN: {
                String result = BooleanDecoder.toTrueFalseBoolean(from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: 
                    case TF_BOOLEAN: 
                    case YN_BOOLEAN: {
                        return BooleanDecoder.toString(from);
                    }
                    case DATE: {
                        return "to_char(?1,'YYYY-MM-DD')";
                    }
                    case TIME: {
                        return "to_char(?1,'HH24:MI:SS')";
                    }
                    case TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                    }
                    case OFFSET_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                    }
                    case ZONE_TIMESTAMP: {
                        return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                    }
                }
                break;
            }
            case DATE: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'YYYY-MM-DD')";
            }
            case TIME: {
                if (from != CastType.STRING) break;
                return "to_date(?1,'HH24:MI:SS')";
            }
            case TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
            }
            case OFFSET_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
            }
            case ZONE_TIMESTAMP: {
                if (from != CastType.STRING) break;
                return "to_timestamp_tz(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "to_number(to_char(?2,'D'))";
            }
            case DAY_OF_MONTH: {
                return "to_number(to_char(?2,'DD'))";
            }
            case DAY_OF_YEAR: {
                return "to_number(to_char(?2,'DDD'))";
            }
            case WEEK: {
                return "to_number(to_char(?2,'IW'))";
            }
            case WEEK_OF_YEAR: {
                return "to_number(to_char(?2,'WW'))";
            }
            case QUARTER: {
                return "to_number(to_char(?2,'Q'))";
            }
            case HOUR: {
                return "to_number(to_char(?2,'HH24'))";
            }
            case MINUTE: {
                return "to_number(to_char(?2,'MI'))";
            }
            case SECOND: {
                return "to_number(to_char(?2,'SS'))";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("(?3+");
        switch (unit) {
            case QUARTER: 
            case YEAR: 
            case MONTH: {
                pattern.append("numtoyminterval");
                break;
            }
            case WEEK: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case DAY: 
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("numtodsinterval");
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        pattern.append("(");
        switch (unit) {
            case WEEK: 
            case QUARTER: 
            case NANOSECOND: {
                pattern.append("(");
            }
        }
        pattern.append("?2");
        switch (unit) {
            case QUARTER: {
                pattern.append(")*3");
                break;
            }
            case WEEK: {
                pattern.append(")*7");
                break;
            }
            case NANOSECOND: {
                pattern.append(")/1e9");
            }
        }
        pattern.append(",'");
        switch (unit) {
            case QUARTER: {
                pattern.append("month");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("second");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("')");
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean timestamp = toTemporalType == TemporalType.TIMESTAMP || fromTemporalType == TemporalType.TIMESTAMP;
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                break;
            }
            case QUARTER: 
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, unit);
                pattern.append(")");
                break;
            }
            case WEEK: 
            case DAY: {
                this.extractField(pattern, TemporalUnit.DAY, unit);
                break;
            }
            case HOUR: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                }
                pattern.append(")");
                break;
            }
            case MINUTE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                }
                pattern.append(")");
                break;
            }
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.DAY, unit);
                if (timestamp) {
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.HOUR, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.MINUTE, unit);
                    pattern.append("+");
                    this.extractField(pattern, TemporalUnit.SECOND, unit);
                }
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + unit);
            }
        }
        return pattern.toString();
    }

    private void extractField(StringBuilder pattern, TemporalUnit unit, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateExtractField(unit));
        pattern.append(" from (?3-?2) ");
        switch (unit) {
            case YEAR: 
            case MONTH: {
                pattern.append("year to month");
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case DAY: {
                pattern.append("day to second");
                break;
            }
            default: {
                throw new SemanticException(unit + " is not a legal field");
            }
        }
        pattern.append(")");
        pattern.append(unit.conversionFactor(toUnit, this));
    }

    protected void registerCharacterTypeMappings() {
        if (this.getVersion() < 900) {
            this.registerColumnType(12, 4000L, "varchar2($l)");
            this.registerColumnType(12, "clob");
        } else {
            this.registerColumnType(1, "char($l char)");
            this.registerColumnType(12, 4000L, "varchar2($l char)");
            this.registerColumnType(12, "clob");
            this.registerColumnType(-9, 4000L, "nvarchar2($l)");
            this.registerColumnType(-9, "nclob");
        }
    }

    protected void registerNumericTypeMappings() {
        this.registerColumnType(16, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(7, "float(24)");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
    }

    protected void registerDateTimeTypeMappings() {
        if (this.getVersion() < 900) {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "date");
            this.registerColumnType(2014, "date");
        } else {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp($p)");
            this.registerColumnType(2014, "timestamp($p) with time zone");
        }
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion() >= 900 ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    protected void registerBinaryTypeMappings() {
        this.registerColumnType(-2, 2000L, "raw($l)");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, 2000L, "raw($l)");
        this.registerColumnType(-3, "blob");
    }

    protected void registerExtendedTypeMappings() {
        if (this.getVersion() >= 1000) {
            this.registerColumnType(3200, "MDSYS.SDO_GEOMETRY");
        }
    }

    protected void registerReverseHibernateTypeMappings() {
    }

    protected void registerDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        if (this.getVersion() < 1200) {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "false");
        } else {
            this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "true");
            this.getDefaultProperties().setProperty("hibernate.jdbc.batch_versioned_data", "true");
        }
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: {
                if (scale == -127) {
                    if (precision <= this.getFloatPrecision()) {
                        return jdbcTypeRegistry.getDescriptor(6);
                    }
                    return jdbcTypeRegistry.getDescriptor(8);
                }
            }
            case 3: {
                if (scale != 0) break;
                switch (precision) {
                    case 1: {
                        return jdbcTypeRegistry.getDescriptor(16);
                    }
                    case 3: {
                        return jdbcTypeRegistry.getDescriptor(-6);
                    }
                    case 5: {
                        return jdbcTypeRegistry.getDescriptor(5);
                    }
                    case 10: {
                        return jdbcTypeRegistry.getDescriptor(4);
                    }
                    case 19: {
                        return jdbcTypeRegistry.getDescriptor(-5);
                    }
                }
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public boolean supportsBitType() {
        return false;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        if (this.getVersion() >= 1200) {
            boolean preferLong = serviceRegistry.getService(ConfigurationService.class).getSetting(PREFER_LONG_RAW, StandardConverters.BOOLEAN, Boolean.valueOf(false));
            BlobJdbcType descriptor = preferLong ? BlobJdbcType.PRIMITIVE_ARRAY_BINDING : BlobJdbcType.DEFAULT;
            typeContributions.contributeJdbcTypeDescriptor(descriptor);
        }
        typeContributions.contributeJdbcTypeDescriptor(NullJdbcType.INSTANCE);
        typeContributions.contributeJdbcTypeDescriptor(ObjectNullAsNullTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new NullType((JdbcType)NullJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object.class))));
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.getVersion() < 1200 ? super.getIdentityColumnSupport() : new Oracle12cIdentityColumnSupport();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        if (this.getVersion() >= 900) {
            return super.getSelectClauseNullString(sqlType);
        }
        switch (sqlType) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: 
            case 2014: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return this.getVersion() < 900 ? "select sysdate from dual" : "select systimestamp from dual";
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return OracleSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from all_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorOracleDatabaseImpl.INSTANCE;
    }

    @Override
    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
                case 30006: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 54: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 4021: {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case 60: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 4020: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 1013: {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                case 1407: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 1000;
    }

    @Override
    public boolean forceLobAsLastValue() {
        return true;
    }

    @Override
    public boolean isEmptyStringTreatedAsNull() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> "HT_" + (name.length() > 27 ? name.substring(0, 27) : name), this, runtimeModelCreationContext), () -> new TempIdTableExporter(false, this::getTypeName){

            @Override
            protected String getCreateOptions() {
                return "on commit delete rows";
            }
        }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        if (StringHelper.isEmpty(sql) || queryOptions == null) {
            return true;
        }
        return DISTINCT_KEYWORD_PATTERN.matcher(sql = sql.toLowerCase(Locale.ROOT)).find() || GROUP_BY_KEYWORD_PATTERN.matcher(sql).find() || UNION_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.hasLimit() && (ORDER_BY_KEYWORD_PATTERN.matcher(sql).find() || queryOptions.getLimit().getFirstRow() != null);
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        String statementType = this.statementType(sql);
        int pos = sql.indexOf(statementType);
        if (pos > -1) {
            StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 8);
            if (pos > 0) {
                buffer.append(sql, 0, pos);
            }
            buffer.append(statementType).append(" /*+ ").append(hints).append(" */").append(sql.substring(pos + statementType.length()));
            sql = buffer.toString();
        }
        return sql;
    }

    @Override
    public int getMaxAliasLength() {
        return 20;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.REF_CURSOR_INSTANCE;
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL";
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    private String statementType(String sql) {
        Matcher matcher = SQL_STATEMENT_TYPE_PATTERN.matcher(sql);
        if (matcher.matches() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't determine SQL statement type for statement: " + sql);
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion() >= 1202;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion() >= 900;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion() >= 1000;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return " for update of " + aliases;
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return " for update of " + aliases + " nowait";
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return " for update skip locked";
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return " for update of " + aliases + " skip locked";
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
            case -1: {
                return lockString;
            }
        }
        return this.supportsWait() ? lockString + " wait " + Math.round((float)timeout / 1000.0f) : lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.getWriteLockString(timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.getWriteLockString(aliases, timeout);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, true, true).result());
    }

    public static Replacer datetimeFormat(String format, boolean useFm, boolean resetFm) {
        String fm = useFm ? "fm" : "";
        String fmReset = resetFm ? fm : "";
        return new Replacer(format, "'", "\"").replace("GG", "AD").replace("G", "AD").replace("yyyy", "YYYY").replace("yyy", fm + "YYYY" + fmReset).replace("yy", "YY").replace("y", fm + "YYYY" + fmReset).replace("MMMM", fm + "Month" + fmReset).replace("MMM", "Mon").replace("MM", "MM").replace("M", fm + "MM" + fmReset).replace("ww", "IW").replace("w", fm + "IW" + fmReset).replace("YYYY", "IYYY").replace("YYY", fm + "IYYY" + fmReset).replace("YY", "IY").replace("Y", fm + "IYYY" + fmReset).replace("W", "W").replace("EEEE", fm + "Day" + fmReset).replace("EEE", "Dy").replace("ee", "D").replace("e", fm + "D" + fmReset).replace("dd", "DD").replace("d", fm + "DD" + fmReset).replace("DDD", "DDD").replace("DD", fm + "DDD" + fmReset).replace("D", fm + "DDD" + fmReset).replace("aa", "AM").replace("a", "AM").replace("hh", "HH12").replace("HH", "HH24").replace("h", fm + "HH12" + fmReset).replace("H", fm + "HH24" + fmReset).replace("mm", "MI").replace("m", fm + "MI" + fmReset).replace("ss", "SS").replace("s", fm + "SS" + fmReset).replace("SSSSSS", "FF6").replace("SSSSS", "FF5").replace("SSSS", "FF4").replace("SSS", "FF3").replace("SS", "FF2").replace("S", "FF1").replace("zzz", "TZR").replace("zz", "TZR").replace("z", "TZR").replace("ZZZ", "TZHTZM").replace("ZZ", "TZHTZM").replace("Z", "TZHTZM").replace("xxx", "TZH:TZM").replace("xx", "TZHTZM").replace("x", "TZH");
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("hextoraw('");
        PrimitiveByteArrayJavaTypeDescriptor.INSTANCE.appendString(appender, bytes);
        appender.appendSql("')");
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        return (ResultSet)statement.getObject(position);
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        statement.registerOutParameter(name, OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType());
        return 1;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        return (ResultSet)statement.getObject(name);
    }
}

