/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.FetchClauseType;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class PostgreSQLSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public PostgreSQLSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        booleanExpressionPredicate.getExpression().accept(this);
    }

    @Override
    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion() >= 1200) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    @Override
    public boolean supportsFilterClause() {
        return this.getDialect().getVersion() >= 940;
    }

    @Override
    protected String getForShare(int timeoutMillis) {
        return " for share";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart || this.isRowsOnlyFetchClauseType(queryPart)) {
            return false;
        }
        return !this.getDialect().supportsFetchClause(queryPart.getFetchClauseType());
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            if (this.getDialect().getVersion() >= 950) {
                this.appendSql("()");
                return;
            } else {
                this.appendSql("(select 1");
                this.appendSql(this.getFromDualForSelectOnly());
                this.appendSql(')');
            }
            return;
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            if (this.getDialect().getVersion() < 950) throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
            return;
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept(this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept(this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        } else {
            this.appendSql(" escape ''");
        }
    }
}

