/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SQLServerSqlAstTranslator;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.SQLServerFormatEmulation;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SQLServerIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2005LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2012LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SQLServer16SequenceSupport;
import org.hibernate.dialect.sequence.SQLServerSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.CastType;
import org.hibernate.query.FetchClauseType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 2100;
    private final int version;
    private StandardSequenceExporter exporter;

    public SQLServerDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion());
        this.registerKeywords(info);
    }

    public SQLServerDialect() {
        this(8);
    }

    public SQLServerDialect(int version) {
        this.version = version;
        this.registerColumnType(8, "float");
        if (this.getVersion() >= 10) {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "datetime2($p)");
            this.registerColumnType(2014, "datetimeoffset($p)");
            this.registerColumnType(3200, "geometry");
        }
        if (this.getVersion() >= 11) {
            this.exporter = new SqlServerSequenceExporter(this);
        }
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(-9, 4000L, "nvarchar($l)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        if (this.getVersion() < 9) {
            this.registerColumnType(-3, "image");
            this.registerColumnType(12, "text");
        } else {
            this.registerColumnType(2004, "varbinary(max)");
            this.registerColumnType(-3, "varbinary(max)");
            this.registerColumnType(2005, "varchar(max)");
            this.registerColumnType(2011, "nvarchar(max)");
            this.registerColumnType(12, "varchar(max)");
            this.registerColumnType(-9, "nvarchar(max)");
        }
        this.registerKeyword("top");
        this.registerKeyword("key");
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return this.getVersion() >= 10 ? TimeZoneSupport.NATIVE : TimeZoneSupport.NONE;
    }

    @Override
    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry().addDescriptor(-6, SmallIntJdbcType.INSTANCE);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        BasicTypeRegistry basicTypeRegistry = queryEngine.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        CommonFunctionFactory.aggregates(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT, "+", "varchar(max)");
        CommonFunctionFactory.avg_castingNonDoubleArguments(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT);
        CommonFunctionFactory.truncate_round(queryEngine);
        CommonFunctionFactory.everyAny_sumIif(queryEngine);
        CommonFunctionFactory.bitLength_pattern(queryEngine, "datalength(?1) * 8");
        if (this.getVersion() >= 10) {
            CommonFunctionFactory.locate_charindex(queryEngine);
            CommonFunctionFactory.stddevPopSamp_stdevp(queryEngine);
            CommonFunctionFactory.varPopSamp_varp(queryEngine);
        }
        if (this.getVersion() >= 11) {
            queryEngine.getSqmFunctionRegistry().register("format", new SQLServerFormatEmulation(this, queryEngine.getTypeConfiguration()));
            CommonFunctionFactory.translate(queryEngine);
            CommonFunctionFactory.median_percentileCont(queryEngine, true);
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datefromparts").setInvariantType(dateType).setExactArgumentCount(3).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("timefromparts").setInvariantType(timeType).setExactArgumentCount(5).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("smalldatetimefromparts").setInvariantType(timestampType).setExactArgumentCount(5).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetimefromparts").setInvariantType(timestampType).setExactArgumentCount(7).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetime2fromparts").setInvariantType(timestampType).setExactArgumentCount(8).register();
            queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("datetimeoffsetfromparts").setInvariantType(timestampType).setExactArgumentCount(10).register();
        }
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SQLServerSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case TIMESTAMP: {
                    return "format(?1,'yyyy-MM-dd HH:mm:ss')";
                }
                case TIME: {
                    return "format(?1,'hh\\:mm\\:ss')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String currentTimestamp() {
        return "sysdatetime()";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public String currentTime() {
        return "convert(time,getdate())";
    }

    @Override
    public String currentDate() {
        return this.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "sysdatetimeoffset()";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.getVersion() >= 11) {
            return SQLServer2012LimitHandler.INSTANCE;
        }
        if (this.getVersion() >= 9) {
            return new SQLServer2005LimitHandler();
        }
        return new TopLimitHandler(false);
    }

    @Override
    public boolean supportsValuesList() {
        return this.getVersion() >= 10;
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select schema_name()";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        if (this.getVersion() >= 16) {
            return true;
        }
        return super.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        if (this.getVersion() >= 16) {
            return true;
        }
        return super.supportsIfExistsBeforeConstraintName();
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        if (this.getVersion() >= 9) {
            LockMode lockMode = lockOptions.getAliasSpecificLockMode(tableName);
            if (lockMode == null) {
                lockMode = lockOptions.getLockMode();
            }
            String writeLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "updlock,holdlock";
            String readLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "holdlock";
            String noWaitStr = lockOptions.getTimeOut() == 0 ? ",nowait" : "";
            String skipLockStr = lockOptions.getTimeOut() == -2 ? ",readpast" : "";
            switch (lockMode) {
                case UPGRADE: 
                case PESSIMISTIC_WRITE: 
                case WRITE: {
                    return tableName + " with (" + writeLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
                }
                case PESSIMISTIC_READ: {
                    return tableName + " with (" + readLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
                }
                case UPGRADE_SKIPLOCKED: {
                    return tableName + " with (updlock,rowlock,readpast" + noWaitStr + ")";
                }
                case UPGRADE_NOWAIT: {
                    return tableName + " with (updlock,holdlock,rowlock,nowait)";
                }
            }
            return tableName;
        }
        switch (lockOptions.getLockMode()) {
            case UPGRADE: 
            case PESSIMISTIC_WRITE: 
            case WRITE: 
            case UPGRADE_NOWAIT: {
                return tableName + " with (updlock,rowlock)";
            }
            case PESSIMISTIC_READ: {
                return tableName + " with (holdlock,rowlock)";
            }
            case UPGRADE_SKIPLOCKED: {
                return tableName + " with (updlock,rowlock,readpast)";
            }
        }
        return tableName;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 2100;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new SQLServerIdentityColumnSupport();
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsSkipLocked() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsNoWait() {
        return this.getVersion() >= 9;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        if (this.getVersion() < 11) {
            return NoSequenceSupport.INSTANCE;
        }
        if (this.getVersion() >= 16) {
            return SQLServer16SequenceSupport.INSTANCE;
        }
        return SQLServerSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getVersion() < 11 ? super.getQuerySequencesString() : "select * from INFORMATION_SCHEMA.SEQUENCES";
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        if (this.getVersion() < 11) {
            return super.getQueryHintString(sql, hints);
        }
        StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 12);
        int pos = sql.indexOf(";");
        if (pos > -1) {
            buffer.append(sql, 0, pos);
        } else {
            buffer.append(sql);
        }
        buffer.append(" OPTION (").append(hints).append(")");
        if (pos > -1) {
            buffer.append(";");
        }
        sql = buffer.toString();
        return sql;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return this.getVersion() < 10;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return this.getVersion() >= 11;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        if (this.getVersion() < 9) {
            return super.buildSQLExceptionConversionDelegate();
        }
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if ("HY008".equals(sqlState)) {
                throw new QueryTimeoutException(message, sqlException, sql);
            }
            if (1222 == errorCode) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 6;
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case TIMEZONE_HOUR: {
                return "(datepart(tz,?2)/60)";
            }
            case TIMEZONE_MINUTE: {
                return "(datepart(tz,?2)%60)";
            }
            case SECOND: {
                return "(datepart(second,?2)+datepart(nanosecond,?2)/1e9)";
            }
            case WEEK: {
                if (this.getVersion() >= 10) break;
                return "(DATEPART(dy,DATEADD(dd,DATEDIFF(dd,'17530101',?2)/7*7,'17530104'))+6)/7)";
            }
        }
        return "datepart(?1,?2)";
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NANOSECOND: {
                return "dateadd(nanosecond,?2%1000000000,dateadd(second,?2/1000000000,?3))";
            }
            case NATIVE: {
                return "dateadd(microsecond,?2%1000000,dateadd(second,?2/1000000,?3))";
            }
        }
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        switch (unit) {
            case NATIVE: {
                return "datediff_big(microsecond,?2,?3)";
            }
        }
        return unit.normalized() == TemporalUnit.NANOSECOND ? "datediff_big(?1,?2,?3)" : "datediff(?1,?2,?3)";
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        switch (unit) {
            case NATIVE: {
                return "microsecond";
            }
        }
        return super.translateDurationField(unit);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "isowk";
            }
            case OFFSET: {
                return "tz";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SQLServerDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "\"").replace("G", "g").replace("EEEE", "dddd").replace("EEE", "ddd").replace("aa", "tt").replace("a", "tt").replace("S", "F").replace("XXX", "K").replace("xxx", "zzz").replace("x", "zz");
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("0x");
        PrimitiveByteArrayJavaTypeDescriptor.INSTANCE.appendString(appender, bytes);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("' as datetimeoffset)");
                    break;
                }
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("' as datetimeoffset)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, calendar);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, calendar, jdbcTimeZone);
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return "collate database_default";
            }
        }
        return "";
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        if (this.getVersion() >= 16) {
            return new String[]{"drop schema if exists " + schemaName};
        }
        return super.getDropSchemaCommand(schemaName);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.BOTH;
    }

    @Override
    public Exporter<Sequence> getSequenceExporter() {
        if (this.exporter == null) {
            return super.getSequenceExporter();
        }
        return this.exporter;
    }

    private class SqlServerSequenceExporter
    extends StandardSequenceExporter {
        public SqlServerSequenceExporter(Dialect dialect) {
            super(dialect);
        }

        @Override
        protected String getFormattedSequenceName(QualifiedSequenceName name, Metadata metadata) {
            if (name.getCatalogName() != null) {
                name = new QualifiedSequenceName(null, name.getSchemaName(), name.getObjectName());
            }
            return super.getFormattedSequenceName(name, metadata);
        }
    }
}

