/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.SybaseSqlAstTranslator;
import org.hibernate.dialect.SybaseSqmToSqlAstConverter;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.SybaseConcatFunction;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.CastType;
import org.hibernate.query.IntervalType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsNullTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private final int version;
    protected final boolean jtdsDriver;
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;

    public SybaseDialect() {
        this(1100, false);
    }

    public SybaseDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10, info.getDriverName() != null && info.getDriverName().contains("jTDS"));
        this.registerKeywords(info);
    }

    public SybaseDialect(int version, boolean jtdsDriver) {
        this.version = version;
        this.jtdsDriver = jtdsDriver;
        this.registerColumnType(-5, "numeric(19,0)");
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision == 19 && scale == 0) {
                    return jdbcTypeRegistry.getDescriptor(-5);
                }
            }
            case -6: {
                if (!this.jtdsDriver) break;
                return jdbcTypeRegistry.getDescriptor(5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            @Override
            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext) {
                return new SybaseSqmToSqlAstConverter<SelectStatement>(sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext);
            }
        };
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeDescriptorRegistry();
        if (this.jtdsDriver) {
            jdbcTypeRegistry.addDescriptor(-6, SmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(2011, ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(-9, ClobJdbcType.CLOB_BINDING);
        } else {
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.STREAM_BINDING_EXTRACTING);
        }
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.PRIMITIVE_ARRAY_BINDING);
        typeContributions.contributeJdbcTypeDescriptor(ObjectNullAsNullTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return this.jtdsDriver ? NationalizationSupport.IMPLICIT : super.getNationalizationSupport();
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.aggregates(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT, "+", "varchar(16384)");
        CommonFunctionFactory.avg_castingNonDoubleArguments(this, queryEngine, SqlAstNodeRenderingMode.DEFAULT);
        queryEngine.getSqmFunctionRegistry().register("concat", new SybaseConcatFunction(this, queryEngine.getTypeConfiguration()));
        CommonFunctionFactory.locate_charindex(queryEngine);
        CommonFunctionFactory.replace_strReplace(queryEngine);
        CommonFunctionFactory.everyAny_sumCaseCase(queryEngine);
        CommonFunctionFactory.bitLength_pattern(queryEngine, "datalength(?1) * 8");
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "str_replace(convert(varchar,?1,102),'.','-')";
                }
                case TIME: {
                    return "convert(varchar,?1,108)";
                }
                case TIMESTAMP: {
                    return "str_replace(convert(varchar,?1,23),'T',' ')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1,?2)";
    }

    @Override
    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1,?2,?3)";
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return super.trimPattern(specification, character).replace("replace", "str_replace");
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Sybase");
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        if (this.version >= 1500) {
            return NameQualifierSupport.BOTH;
        }
        return NameQualifierSupport.CATALOG;
    }
}

