/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.Limit;

public abstract class AbstractNoOffsetLimitHandler
extends AbstractLimitHandler {
    private final boolean variableLimit;

    public AbstractNoOffsetLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    protected abstract String limitClause();

    protected abstract String insert(String var1, String var2);

    @Override
    public String processSql(String sql, Limit limit) {
        if (!AbstractNoOffsetLimitHandler.hasMaxRows(limit)) {
            return sql;
        }
        String limitClause = this.limitClause();
        if (!this.supportsVariableLimit()) {
            String limitLiteral = String.valueOf(this.getMaxOrLimit(limit));
            limitClause = limitClause.replace("?", limitLiteral);
        }
        return this.insert(limitClause, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean supportsLimitOffset() {
        return false;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    @Override
    public abstract boolean bindLimitParametersFirst();
}

