/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.Limit;

public class OffsetFetchLimitHandler
extends AbstractLimitHandler {
    public static final OffsetFetchLimitHandler INSTANCE = new OffsetFetchLimitHandler(true);
    private final boolean variableLimit;

    public OffsetFetchLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    @Override
    public String processSql(String sql, Limit limit) {
        boolean hasFirstRow = OffsetFetchLimitHandler.hasFirstRow(limit);
        boolean hasMaxRows = OffsetFetchLimitHandler.hasMaxRows(limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder offsetFetch = new StringBuilder();
        this.begin(sql, offsetFetch, hasFirstRow, hasMaxRows);
        if (hasFirstRow) {
            offsetFetch.append(" offset ");
            if (this.supportsVariableLimit()) {
                offsetFetch.append("?");
            } else {
                offsetFetch.append(limit.getFirstRow());
            }
            if (this.renderOffsetRowsKeyword()) {
                offsetFetch.append(" rows");
            }
        }
        if (hasMaxRows) {
            if (hasFirstRow) {
                offsetFetch.append(" fetch next ");
            } else {
                offsetFetch.append(" fetch first ");
            }
            if (this.supportsVariableLimit()) {
                offsetFetch.append("?");
            } else {
                offsetFetch.append(this.getMaxOrLimit(limit));
            }
            offsetFetch.append(" rows only");
        }
        return this.insert(offsetFetch.toString(), sql);
    }

    void begin(String sql, StringBuilder offsetFetch, boolean hasFirstRow, boolean hasMaxRows) {
    }

    String insert(String offsetFetch, String sql) {
        return this.insertBeforeForUpdate(offsetFetch, sql);
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }

    protected boolean renderOffsetRowsKeyword() {
        return true;
    }
}

