/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public class CollectionLoaderSubSelectFetch
implements CollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final SubselectFetch subselect;
    private final SelectStatement sqlAst;

    public CollectionLoaderSubSelectFetch(PluralAttributeMapping attributeMapping, DomainResult cachedDomainResult, SubselectFetch subselect, SharedSessionContractImplementor session) {
        this.attributeMapping = attributeMapping;
        this.subselect = subselect;
        this.sqlAst = LoaderSelectBuilder.createSubSelectFetchSelect(attributeMapping, subselect, cachedDomainResult, session.getLoadQueryInfluencers(), LockOptions.NONE, jdbcParameter -> {}, session.getFactory());
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.attributeMapping;
    }

    @Override
    public PersistentCollection<?> load(Object triggerKey, final SharedSessionContractImplementor session) {
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), triggerKey);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        PersistentCollection collection = persistenceContext.getCollection(collectionKey);
        this.attributeMapping.getCollectionDescriptor().getCollectionType().getKeyOfOwner(collection.getOwner(), session);
        EntityEntry ownerEntry = persistenceContext.getEntry(collection.getOwner());
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        EntityKey triggerKeyOwnerKey = ownerEntry.getEntityKey();
        SubselectFetch registeredFetch = batchFetchQueue.getSubselect(triggerKeyOwnerKey);
        ArrayList<PersistentCollection> subSelectFetchedCollections = null;
        if (registeredFetch != null) {
            subSelectFetchedCollections = CollectionHelper.arrayList(registeredFetch.getResultingEntityKeys().size());
            for (EntityKey key : registeredFetch.getResultingEntityKeys()) {
                PersistentCollection containedCollection = persistenceContext.getCollection(new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key.getIdentifier()));
                if (containedCollection == collection) continue;
                containedCollection.beginRead();
                containedCollection.beforeInitialize(this.getLoadable().getCollectionDescriptor(), -1);
                subSelectFetchedCollections.add(containedCollection);
            }
        }
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlAst).translate(this.subselect.getLoadingJdbcParameterBindings(), QueryOptions.NONE);
        final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler(batchFetchQueue, this.sqlAst, this.subselect.getLoadingJdbcParameters(), this.subselect.getLoadingJdbcParameterBindings());
        jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, this.subselect.getLoadingJdbcParameterBindings(), new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
                subSelectFetchableKeysHandler.addKey(entityKey);
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerPassThruImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        if (subSelectFetchedCollections != null && !subSelectFetchedCollections.isEmpty()) {
            subSelectFetchedCollections.forEach(c -> {
                if (c.wasInitialized()) {
                    return;
                }
                c.initializeEmptyCollection(this.getLoadable().getCollectionDescriptor());
                ResultsHelper.finalizeCollectionLoading(persistenceContext, this.getLoadable().getCollectionDescriptor(), c, c.getKey(), true);
            });
            subSelectFetchedCollections.clear();
        }
        return collection;
    }
}

