/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.jboss.logging.Logger;

public class MultiIdLoaderStandard<T>
implements MultiIdEntityLoader<T> {
    private static final Logger log = Logger.getLogger(MultiIdLoaderStandard.class);
    private final EntityPersister entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private int idJdbcTypeCount = -1;

    public MultiIdLoaderStandard(EntityPersister entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public EntityPersister getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public List<T> load(Object[] ids, MultiIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        assert (ids != null);
        if (this.idJdbcTypeCount < 0) {
            this.idJdbcTypeCount = this.entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        }
        if (loadOptions.isOrderReturnEnabled()) {
            return this.performOrderedMultiLoad(ids, session, loadOptions);
        }
        return this.performUnorderedMultiLoad(ids, session, loadOptions);
    }

    private List<T> performOrderedMultiLoad(Object[] ids, SharedSessionContractImplementor session, MultiIdLoadOptions loadOptions) {
        if (log.isTraceEnabled()) {
            log.tracef("#performOrderedMultiLoad(`%s`, ..)", (Object)this.entityDescriptor.getEntityName());
        }
        assert (loadOptions.isOrderReturnEnabled());
        JdbcEnvironment jdbcEnvironment = this.sessionFactory.getJdbcServices().getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        ArrayList result = CollectionHelper.arrayList(ids.length);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : dialect.getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.idJdbcTypeCount, ids.length, this.sessionFactory.getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        ArrayList<Object> idsInBatch = new ArrayList<Object>();
        ArrayList<Integer> elementPositionsLoadedByBatch = new ArrayList<Integer>();
        boolean coerce = !this.sessionFactory.getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        for (int i = 0; i < ids.length; ++i) {
            Object id = coerce ? this.entityDescriptor.getIdentifierMapping().getJavaTypeDescriptor().coerce(ids[i], session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.entityDescriptor);
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, this.entityDescriptor.getMappedClass().getName(), lockOptions, (EventSource)session, this.getReadOnlyFromLoadQueryInfluencers(session));
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.entityDescriptor, entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    continue;
                }
            }
            idsInBatch.add(id);
            if (idsInBatch.size() >= maxBatchSize) {
                this.loadEntitiesById(idsInBatch, lockOptions, session);
                idsInBatch.clear();
            }
            result.add(i, entityKey);
            elementPositionsLoadedByBatch.add(i);
        }
        if (!idsInBatch.isEmpty()) {
            this.loadEntitiesById(idsInBatch, lockOptions, session);
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        for (Integer position : elementPositionsLoadedByBatch) {
            EntityEntry entry;
            EntityKey entityKey = (EntityKey)result.get(position);
            Object entity = persistenceContext.getEntity(entityKey);
            if (!(entity == null || loadOptions.isReturnOfDeletedEntitiesEnabled() || (entry = persistenceContext.getEntry(entity)).getStatus() != Status.DELETED && entry.getStatus() != Status.GONE)) {
                entity = null;
            }
            result.set(position, entity);
        }
        return result;
    }

    private List<T> loadEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, final SharedSessionContractImplementor session) {
        assert (idsInBatch != null);
        assert (!idsInBatch.isEmpty());
        assert (this.idJdbcTypeCount > 0);
        int numberOfIdsInBatch = idsInBatch.size();
        if (log.isTraceEnabled()) {
            log.tracef("#loadEntitiesById(`%s`, `%s`, ..)", (Object)this.entityDescriptor.getEntityName(), (Object)numberOfIdsInBatch);
        }
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>(numberOfIdsInBatch * this.idJdbcTypeCount);
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, numberOfIdsInBatch, session.getLoadQueryInfluencers(), lockOptions, jdbcParameters::add, this.sessionFactory);
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = 0;
        for (int i = 0; i < numberOfIdsInBatch; ++i) {
            Object id = idsInBatch.get(i);
            offset += jdbcParameterBindings.registerParametersForEachJdbcValue(id, Clause.WHERE, offset, this.entityDescriptor.getIdentifierMapping(), jdbcParameters, session);
        }
        assert (offset == jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(this.sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = this.entityDescriptor.hasSubselectLoadableCollections() ? SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, jdbcParameters, jdbcParameterBindings) : null;
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }

            @Override
            public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
                if (subSelectFetchableKeysHandler != null) {
                    subSelectFetchableKeysHandler.addKey(entityKey);
                }
            }
        }, RowTransformerPassThruImpl.instance(), ListResultsConsumer.UniqueSemantic.FILTER);
        return list;
    }

    private List<T> performUnorderedMultiLoad(Object[] ids, SharedSessionContractImplementor session, MultiIdLoadOptions loadOptions) {
        LockOptions lockOptions;
        assert (!loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (log.isTraceEnabled()) {
            log.tracef("#performUnorderedMultiLoad(`%s`, ..)", (Object)this.entityDescriptor.getEntityName());
        }
        ArrayList result = CollectionHelper.arrayList(ids.length);
        LockOptions lockOptions2 = lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
            boolean foundAnyManagedEntities = false;
            ArrayList<Object> nonManagedIds = new ArrayList<Object>();
            boolean coerce = !this.sessionFactory.getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
            for (int i = 0; i < ids.length; ++i) {
                Object id = coerce ? this.entityDescriptor.getIdentifierMapping().getJavaTypeDescriptor().coerce(ids[i], session) : ids[i];
                EntityKey entityKey = new EntityKey(id, this.entityDescriptor);
                LoadEvent loadEvent = new LoadEvent(id, this.entityDescriptor.getMappedClass().getName(), lockOptions, (EventSource)session, this.getReadOnlyFromLoadQueryInfluencers(session));
                Object managedEntity = null;
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET);
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    foundAnyManagedEntities = true;
                    result.add(null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.entityDescriptor, entityKey);
                }
                if (managedEntity != null) {
                    foundAnyManagedEntities = true;
                    result.add(managedEntity);
                    continue;
                }
                nonManagedIds.add(id);
            }
            if (foundAnyManagedEntities) {
                if (nonManagedIds.isEmpty()) {
                    return result;
                }
                ids = nonManagedIds.toArray((Object[])Array.newInstance(ids.getClass().getComponentType(), nonManagedIds.size()));
            }
        }
        int numberOfIdsLeft = ids.length;
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getDefaultBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.entityDescriptor.getIdentifierType().getColumnSpan(session.getFactory()), numberOfIdsLeft, this.sessionFactory.getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        int idPosition = 0;
        while (numberOfIdsLeft > 0) {
            int batchSize = Math.min(numberOfIdsLeft, maxBatchSize);
            Object[] idsInBatch = new Object[batchSize];
            System.arraycopy(ids, idPosition, idsInBatch, 0, batchSize);
            result.addAll(this.loadEntitiesById(Arrays.asList(idsInBatch), lockOptions, session));
            numberOfIdsLeft -= batchSize;
            idPosition += batchSize;
        }
        return result;
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers(SharedSessionContractImplementor session) {
        Boolean readOnly = null;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (loadQueryInfluencers != null) {
            readOnly = loadQueryInfluencers.getReadOnly();
        }
        return readOnly;
    }
}

