/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.SingleEntityLoadPlan;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;

public class SingleIdLoadPlan<T>
implements SingleEntityLoadPlan {
    private final org.hibernate.persister.entity.Loadable persister;
    private final ModelPart restrictivePart;
    private final LockOptions lockOptions;
    private final JdbcSelect jdbcSelect;
    private final List<JdbcParameter> jdbcParameters;

    public SingleIdLoadPlan(org.hibernate.persister.entity.Loadable persister, ModelPart restrictivePart, SelectStatement sqlAst, List<JdbcParameter> jdbcParameters, final LockOptions lockOptions, SessionFactoryImplementor sessionFactory) {
        this.persister = persister;
        this.restrictivePart = restrictivePart;
        this.lockOptions = lockOptions.makeCopy();
        this.jdbcParameters = jdbcParameters;
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(null, new QueryOptionsAdapter(){

            @Override
            public LockOptions getLockOptions() {
                return lockOptions;
            }
        });
    }

    @Override
    public Loadable getLoadable() {
        return this.persister;
    }

    @Override
    public ModelPart getRestrictivePart() {
        return this.restrictivePart;
    }

    @Override
    public JdbcSelect getJdbcSelect() {
        return this.jdbcSelect;
    }

    protected RowTransformer<T> getRowTransformer() {
        return RowTransformerPassThruImpl.instance();
    }

    public T load(Object restrictedValue, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, null, false, session);
    }

    public T load(Object restrictedValue, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, readOnly, false, session);
    }

    public T load(Object restrictedValue, Boolean readOnly, Boolean singleResultExpected, SharedSessionContractImplementor session) {
        return this.load(restrictedValue, null, readOnly, singleResultExpected, session);
    }

    public T load(final Object restrictedValue, final Object entityInstance, Boolean readOnly, Boolean singleResultExpected, final SharedSessionContractImplementor session) {
        int offset;
        int jdbcTypeCount = this.restrictivePart.getJdbcTypeCount();
        assert (this.jdbcParameters.size() % jdbcTypeCount == 0);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcTypeCount);
        this.jdbcSelect.bindFilterJdbcParameters(jdbcParameterBindings);
        for (offset = 0; offset < this.jdbcParameters.size(); offset += jdbcParameterBindings.registerParametersForEachJdbcValue(restrictedValue, Clause.WHERE, offset, this.restrictivePart, this.jdbcParameters, session)) {
        }
        assert (offset == this.jdbcParameters.size());
        final SimpleQueryOptions queryOptions = new SimpleQueryOptions(this.lockOptions, readOnly);
        final CallbackImpl callback = new CallbackImpl();
        List<T> list = JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public Object getEntityInstance() {
                return entityInstance;
            }

            @Override
            public Object getEntityId() {
                return restrictedValue;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            @Override
            public String getQueryIdentifier(String sql) {
                return sql;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return callback;
            }
        }, this.getRowTransformer(), singleResultExpected != false ? ListResultsConsumer.UniqueSemantic.ASSERT : ListResultsConsumer.UniqueSemantic.FILTER);
        if (list.isEmpty()) {
            return null;
        }
        T entity = list.get(0);
        if (this.persister != null) {
            callback.invokeAfterLoadActions(session, entity, this.persister);
        }
        return entity;
    }
}

