/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.collection.internal.StandardMapSemantics;
import org.hibernate.collection.internal.StandardOrderedMapSemantics;
import org.hibernate.collection.internal.StandardSortedMapSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.MapType;
import org.hibernate.type.OrderedMapType;
import org.hibernate.type.SortedMapType;

public class Map
extends IndexedCollection {
    private String mapKeyPropertyName;

    public Map(MetadataBuildingContext buildingContext, PersistentClass owner) {
        super(buildingContext, owner);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    public String getMapKeyPropertyName() {
        return this.mapKeyPropertyName;
    }

    public void setMapKeyPropertyName(String mapKeyPropertyName) {
        this.mapKeyPropertyName = mapKeyPropertyName;
    }

    @Override
    public CollectionSemantics getDefaultCollectionSemantics() {
        if (this.isSorted()) {
            return StandardSortedMapSemantics.INSTANCE;
        }
        if (this.hasOrder()) {
            return StandardOrderedMapSemantics.INSTANCE;
        }
        return StandardMapSemantics.INSTANCE;
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return new SortedMapType(this.getTypeConfiguration(), this.getRole(), this.getReferencedPropertyName(), this.getComparator());
        }
        if (this.hasOrder()) {
            return new OrderedMapType(this.getTypeConfiguration(), this.getRole(), this.getReferencedPropertyName());
        }
        return new MapType(this.getTypeConfiguration(), this.getRole(), this.getReferencedPropertyName());
    }

    @Override
    public void createAllKeys() throws MappingException {
        super.createAllKeys();
        if (!this.isInverse()) {
            this.getIndex().createForeignKey();
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

