/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractEntityInstantiatorPojo
extends AbstractPojoInstantiator
implements EntityInstantiator {
    private final EntityMetamodel entityMetamodel;
    private final Class<?> proxyInterface;
    private final boolean applyBytecodeInterception;

    public AbstractEntityInstantiatorPojo(EntityMetamodel entityMetamodel, PersistentClass persistentClass, JavaType<?> javaTypeDescriptor) {
        super(javaTypeDescriptor.getJavaTypeClass());
        this.entityMetamodel = entityMetamodel;
        this.proxyInterface = persistentClass.getProxyInterface();
        this.applyBytecodeInterception = PersistentAttributeInterceptable.class.isAssignableFrom(persistentClass.getMappedClass());
    }

    protected Object applyInterception(Object entity) {
        if (!this.applyBytecodeInterception) {
            return entity;
        }
        LazyAttributeLoadingInterceptor interceptor = new LazyAttributeLoadingInterceptor(this.entityMetamodel.getName(), null, this.entityMetamodel.getBytecodeEnhancementMetadata().getLazyAttributesMetadata().getLazyAttributeNames(), null);
        ((PersistentAttributeInterceptable)entity).$$_hibernate_setInterceptor(interceptor);
        return entity;
    }

    @Override
    public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
        return super.isInstance(object, sessionFactory) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

