/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.function.Supplier;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableInstantiatorPojoOptimized
extends AbstractPojoInstantiator
implements StandardEmbeddableInstantiator {
    private final Supplier<EmbeddableMappingType> embeddableMappingAccess;
    private final ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer;

    public EmbeddableInstantiatorPojoOptimized(JavaType<?> javaTypeDescriptor, Supplier<EmbeddableMappingType> embeddableMappingAccess, ReflectionOptimizer.InstantiationOptimizer instantiationOptimizer) {
        super(javaTypeDescriptor.getJavaTypeClass());
        this.embeddableMappingAccess = embeddableMappingAccess;
        this.instantiationOptimizer = instantiationOptimizer;
    }

    @Override
    public Object instantiate(Supplier<Object[]> valuesAccess, SessionFactoryImplementor sessionFactory) {
        Object embeddable = this.instantiationOptimizer.newInstance();
        EmbeddableMappingType embeddableMapping = this.embeddableMappingAccess.get();
        embeddableMapping.setValues(embeddable, valuesAccess.get());
        return embeddable;
    }
}

