/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.internal.AbstractDynamicMapInstantiator;
import org.hibernate.metamodel.spi.EntityInstantiator;

public class EntityInstantiatorDynamicMap
extends AbstractDynamicMapInstantiator
implements EntityInstantiator {
    private final Set<String> entityRoleNames = new HashSet<String>();
    public static final EntityNameResolver ENTITY_NAME_RESOLVER = entity -> {
        if (!(entity instanceof Map)) {
            return null;
        }
        String entityName = EntityInstantiatorDynamicMap.extractEmbeddedEntityName((Map)entity);
        if (entityName == null) {
            throw new HibernateException("Could not determine type of dynamic map entity");
        }
        return entityName;
    };

    public EntityInstantiatorDynamicMap(PersistentClass bootDescriptor) {
        super(bootDescriptor.getEntityName());
        this.entityRoleNames.add(this.getRoleName());
        if (bootDescriptor.hasSubclasses()) {
            Iterator<PersistentClass> itr = bootDescriptor.getSubclassClosureIterator();
            while (itr.hasNext()) {
                PersistentClass subclassInfo = itr.next();
                this.entityRoleNames.add(subclassInfo.getEntityName());
            }
        }
    }

    @Override
    public Object instantiate(SessionFactoryImplementor sessionFactory) {
        return this.generateDataMap();
    }

    @Override
    protected boolean isSameRole(String type) {
        return super.isSameRole(type) || this.isPartOfHierarchy(type);
    }

    private boolean isPartOfHierarchy(String type) {
        return this.entityRoleNames.contains(type);
    }

    public static String extractEmbeddedEntityName(Map<?, ?> entity) {
        if (entity == null) {
            return null;
        }
        String entityName = (String)entity.get("$type$");
        if (entityName == null) {
            throw new HibernateException("Could not determine type of dynamic map entity");
        }
        return entityName;
    }
}

