/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public interface EntityMappingType
extends ManagedMappingType,
EntityValuedModelPart,
Loadable {
    public EntityPersister getEntityPersister();

    default public String getContributor() {
        return "orm";
    }

    default public EntityRepresentationStrategy getRepresentationStrategy() {
        return this.getEntityPersister().getRepresentationStrategy();
    }

    public String getEntityName();

    @Override
    default public EntityMappingType findContainingEntityMapping() {
        return this;
    }

    @Override
    default public String getPartName() {
        return this.getEntityName();
    }

    @Override
    default public String getRootPathName() {
        return this.getEntityName();
    }

    @Override
    default public JavaType<?> getJavaTypeDescriptor() {
        return this.getMappedJavaTypeDescriptor();
    }

    @Override
    default public MappingType getPartMappingType() {
        return this;
    }

    public void visitQuerySpaces(Consumer<String> var1);

    @Override
    default public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    @Override
    default public ModelPart findSubPart(String name, EntityMappingType targetType) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType targetType) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public int getJdbcTypeCount() {
        return this.forEachJdbcType((index, jdbcMapping) -> {});
    }

    @Override
    default public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    default public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        return this.forEachDisassembledJdbcValue(this.disassemble(value, session), clause, offset, consumer, session);
    }

    default public boolean hasSubclasses() {
        return this.getEntityPersister().getEntityMetamodel().hasSubclasses();
    }

    default public AttributeMapping findDeclaredAttributeMapping(String name) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public int getNumberOfDeclaredAttributeMappings() {
        return this.getDeclaredAttributeMappings().size();
    }

    default public Collection<AttributeMapping> getDeclaredAttributeMappings() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public void visitDeclaredAttributeMappings(Consumer<? super AttributeMapping> action) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public EntityMappingType getSuperMappingType() {
        return null;
    }

    default public boolean isTypeOrSuperType(EntityMappingType targetType) {
        return targetType == this;
    }

    default public boolean isTypeOrSuperType(ManagedMappingType targetType) {
        if (targetType instanceof EntityMappingType) {
            return this.isTypeOrSuperType((EntityMappingType)targetType);
        }
        return false;
    }

    default public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy() {
        return this.getEntityPersister().getSqmMultiTableMutationStrategy();
    }

    public EntityIdentifierMapping getIdentifierMapping();

    public EntityDiscriminatorMapping getDiscriminatorMapping();

    public Object getDiscriminatorValue();

    public String getSubclassForDiscriminatorValue(Object var1);

    public EntityVersionMapping getVersionMapping();

    public NaturalIdMapping getNaturalIdMapping();

    public EntityRowIdMapping getRowIdMapping();

    default public void visitAttributeMappings(Consumer<? super AttributeMapping> action, EntityMappingType targetType) {
        this.getAttributeMappings().forEach(action);
    }

    default public void visitSubTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
    }

    default public void visitSuperTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
    }

    default public void visitConstraintOrderedTables(ConstraintOrderedTableConsumer consumer) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    default public EntityMappingType getRootEntityDescriptor() {
        EntityMappingType superMappingType = this.getSuperMappingType();
        if (superMappingType == null) {
            return this;
        }
        return superMappingType.getRootEntityDescriptor();
    }

    default public void pruneForSubclasses(TableGroup tableGroup, Set<String> treatedEntityNames) {
    }

    default public boolean isAbstract() {
        return this.getEntityPersister().getEntityMetamodel().isAbstract();
    }

    @Override
    default public void visitAttributeMappings(Consumer<? super AttributeMapping> action) {
        this.getAttributeMappings().forEach(action);
    }

    default public Object[] extractConcreteTypeStateValues(Map<AttributeMapping, DomainResultAssembler> assemblerMapping, RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.getNumberOfAttributeMappings()];
        this.visitStateArrayContributors(attribute -> {
            DomainResultAssembler assembler = (DomainResultAssembler)assemblerMapping.get(attribute);
            Serializable value = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
            values[attribute.getStateArrayPosition()] = value;
        });
        return values;
    }

    @Override
    default public void visitStateArrayContributors(Consumer<StateArrayContributorMapping> mappingConsumer) {
        this.visitAttributeMappings(attributeMapping -> mappingConsumer.accept((StateArrayContributorMapping)attributeMapping));
    }

    public NaturalIdLoader<?> getNaturalIdLoader();

    public MultiNaturalIdLoader<?> getMultiNaturalIdLoader();

    @Override
    default public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFilters(influencers);
    }

    @Override
    default public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEntityGraph(influencers);
    }

    @Override
    default public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    default public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState, SqlAstCreationContext creationContext) {
        return this.createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, additionalPredicateCollectorAccess, creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem()), creationState.getSqlExpressionResolver(), creationState.getFromClauseAccess(), creationContext);
    }

    @Override
    default public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAliasBase sqlAliasBase, SqlExpressionResolver expressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        return this.getEntityPersister().createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, additionalPredicateCollectorAccess, sqlAliasBase, expressionResolver, fromClauseAccess, creationContext);
    }

    default public TableReference createPrimaryTableReference(SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        throw new UnsupportedMappingException("Entity mapping does not support primary TableReference creation [" + this.getClass().getName() + " : " + this.getEntityName() + "]");
    }

    default public TableReferenceJoin createTableReferenceJoin(String joinTableExpression, SqlAliasBase sqlAliasBase, TableReference lhs, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        throw new UnsupportedMappingException("Entity mapping does not support primary TableReference join creation [" + this.getClass().getName() + " : " + this.getEntityName() + "]");
    }

    @Override
    default public int getNumberOfAttributeMappings() {
        return this.getEntityPersister().getNumberOfAttributeMappings();
    }

    @Override
    default public List<AttributeMapping> getAttributeMappings() {
        return this.getEntityPersister().getAttributeMappings();
    }

    @Override
    default public AttributeMapping getAttributeMapping(int position) {
        return this.getEntityPersister().getAttributeMapping(position);
    }

    default public JavaType getMappedJavaTypeDescriptor() {
        return this.getEntityPersister().getMappedJavaTypeDescriptor();
    }

    @Override
    default public String getSqlAliasStem() {
        return this.getEntityPersister().getSqlAliasStem();
    }

    @Override
    default public int getNumberOfFetchables() {
        return this.getEntityPersister().getNumberOfFetchables();
    }

    public static interface ConstraintOrderedTableConsumer {
        public void consume(String var1, Supplier<Consumer<SelectableConsumer>> var2);
    }
}

