/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.NoValueGeneration;
import org.hibernate.metamodel.mapping.internal.NonAggregatedIdentifierMappingImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.TreatedNavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.MappedByTableGroup;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchSelectImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultJoinedSubclassImpl;
import org.hibernate.sql.results.internal.domain.CircularBiDirectionalFetchImpl;
import org.hibernate.sql.results.internal.domain.CircularFetchImpl;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ToOneAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedFetchable,
EntityAssociationMapping,
TableGroupJoinProducer {
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean isKeyTableNullable;
    private final boolean isConstrained;
    private final boolean isIgnoreNotFound;
    private final boolean unwrapProxy;
    private final boolean isOptional;
    private final EntityMappingType entityMappingType;
    private final String referencedPropertyName;
    private final String targetKeyPropertyName;
    private final Set<String> targetKeyPropertyNames;
    private final Cardinality cardinality;
    private final String bidirectionalAttributeName;
    private final TableGroupProducer declaringTableGroupProducer;
    private ForeignKeyDescriptor foreignKeyDescriptor;
    private ForeignKeyDescriptor.Nature sideNature;
    private String identifyingColumnsTableExpression;
    private boolean canUseParentTableGroup;

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, ToOne bootValue, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchOptions mappedFetchOptions, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        this(name, navigableRole, stateArrayPosition, bootValue, attributeMetadataAccess, mappedFetchOptions.getTiming(), mappedFetchOptions.getStyle(), entityMappingType, declaringType, declaringEntityPersister, propertyAccess);
    }

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, ToOne bootValue, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchTiming mappedFetchTiming, FetchStyle mappedFetchStyle, EntityMappingType entityMappingType, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchTiming, mappedFetchStyle, declaringType, propertyAccess, NoValueGeneration.INSTANCE);
        Type propertyType;
        HashSet<String> targetKeyPropertyNames;
        String bidirectionalAttributeName;
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = bootValue.isNullable();
        this.referencedPropertyName = bootValue.getReferencedPropertyName();
        this.unwrapProxy = bootValue.isUnwrapProxy();
        this.entityMappingType = entityMappingType;
        if (bootValue instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)bootValue;
            this.isIgnoreNotFound = ((ManyToOne)bootValue).isIgnoreNotFound();
            this.cardinality = manyToOne.isLogicalOneToOne() ? Cardinality.LOGICAL_ONE_TO_ONE : Cardinality.MANY_TO_ONE;
            if (this.referencedPropertyName == null) {
                bidirectionalAttributeName = null;
                PersistentClass entityBinding = manyToOne.getMetadata().getEntityBinding(manyToOne.getReferencedEntityName());
                if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE) {
                    Iterator<Join> joinClosureIterator = entityBinding.getJoinClosureIterator();
                    while (joinClosureIterator.hasNext()) {
                        Join join = joinClosureIterator.next();
                        if (!join.getPersistentClass().getEntityName().equals(entityBinding.getEntityName()) || join.getPropertySpan() != 1 || join.getTable() != manyToOne.getTable() || !this.equal(join.getKey().getColumnIterator(), manyToOne.getColumnIterator())) continue;
                        bidirectionalAttributeName = join.getPropertyIterator().next().getName();
                        break;
                    }
                    if (bidirectionalAttributeName == null) {
                        Iterator<Property> propertyClosureIterator = entityBinding.getPropertyClosureIterator();
                        while (propertyClosureIterator.hasNext()) {
                            Property property = propertyClosureIterator.next();
                            if (!(property.getValue() instanceof OneToOne) || !name.equals(((OneToOne)property.getValue()).getMappedByProperty())) continue;
                            bidirectionalAttributeName = property.getName();
                            break;
                        }
                    }
                } else {
                    Iterator<Property> propertyClosureIterator = entityBinding.getPropertyClosureIterator();
                    while (propertyClosureIterator.hasNext()) {
                        Property property = propertyClosureIterator.next();
                        if (!(property.getValue() instanceof Collection) || !name.equals(((Collection)property.getValue()).getMappedByProperty())) continue;
                        bidirectionalAttributeName = property.getName();
                        break;
                    }
                }
                this.bidirectionalAttributeName = bidirectionalAttributeName;
            } else {
                this.bidirectionalAttributeName = this.referencedPropertyName;
            }
            if (bootValue.isNullable()) {
                this.isKeyTableNullable = true;
            } else {
                JdbcServices jdbcServices = declaringEntityPersister.getFactory().getJdbcServices();
                String targetTableName = jdbcServices.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(manyToOne.getTable().getQualifiedTableName(), jdbcServices.getDialect());
                if (CollectionPart.Nature.fromNameExact(navigableRole.getParent().getLocalName()) != null) {
                    PluralAttributeMapping pluralAttribute = (PluralAttributeMapping)declaringEntityPersister.resolveSubPart(navigableRole.getParent().getParent());
                    QueryableCollection persister = (QueryableCollection)pluralAttribute.getCollectionDescriptor();
                    this.isKeyTableNullable = !persister.getTableName().equals(targetTableName);
                } else {
                    AbstractEntityPersister persister = (AbstractEntityPersister)declaringEntityPersister;
                    int tableIndex = ArrayHelper.indexOf(persister.getTableNames(), targetTableName);
                    this.isKeyTableNullable = persister.isNullableTable(tableIndex);
                }
            }
            this.isOptional = ((ManyToOne)bootValue).isIgnoreNotFound();
        } else {
            assert (bootValue instanceof OneToOne);
            this.cardinality = Cardinality.ONE_TO_ONE;
            OneToOne oneToOne = (OneToOne)bootValue;
            bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(oneToOne.getMappedByProperty(), Character.valueOf('.'));
            this.bidirectionalAttributeName = bidirectionalAttributeName == null ? StringHelper.subStringNullIfEmpty(this.referencedPropertyName, Character.valueOf('.')) : bidirectionalAttributeName;
            this.isIgnoreNotFound = this.isNullable();
            this.isKeyTableNullable = this.isNullable();
            this.isOptional = !bootValue.isConstrained();
        }
        this.isConstrained = bootValue.isConstrained();
        this.navigableRole = navigableRole;
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(this.getNavigableRole().getParent().getLocalName());
        if (nature == null) {
            this.declaringTableGroupProducer = declaringEntityPersister;
        } else {
            String collectionRoleName = this.getNavigableRole().getParent().getParent().getLocalName();
            this.declaringTableGroupProducer = (PluralAttributeMapping)declaringEntityPersister.findAttributeMapping(collectionRoleName.substring(collectionRoleName.lastIndexOf(46) + 1));
        }
        if (this.referencedPropertyName == null) {
            targetKeyPropertyNames = new HashSet<String>(2);
            targetKeyPropertyNames.add("{id}");
            IdentifierProperty identifierProperty = this.getEntityMappingType().getEntityPersister().getEntityMetamodel().getIdentifierProperty();
            propertyType = identifierProperty.getType();
            if (identifierProperty.getName() == null) {
                CompositeType compositeType;
                if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                    this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, compositeType.getSubtypes()[0], declaringEntityPersister.getFactory());
                } else {
                    this.targetKeyPropertyName = "{id}";
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, null, propertyType, declaringEntityPersister.getFactory());
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
                }
            } else {
                this.targetKeyPropertyName = identifierProperty.getName();
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, propertyType, declaringEntityPersister.getFactory());
            }
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else if (bootValue.isReferenceToPrimaryKey()) {
            this.targetKeyPropertyName = this.referencedPropertyName;
            targetKeyPropertyNames = new HashSet(2);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, this.targetKeyPropertyName, bootValue.getType(), declaringEntityPersister.getFactory());
            this.targetKeyPropertyNames = targetKeyPropertyNames;
        } else {
            CompositeType compositeType;
            EntityMetamodel entityMetamodel = entityMappingType.getEntityPersister().getEntityMetamodel();
            int propertyIndex = entityMetamodel.getPropertyIndex(this.referencedPropertyName);
            propertyType = entityMetamodel.getPropertyTypes()[propertyIndex];
            if (propertyType.isComponentType() && (compositeType = (CompositeType)propertyType).isEmbedded() && compositeType.getPropertyNames().length == 1) {
                this.targetKeyPropertyName = compositeType.getPropertyNames()[0];
                this.targetKeyPropertyNames = Collections.singleton(this.targetKeyPropertyName);
            } else {
                this.targetKeyPropertyName = this.referencedPropertyName;
                String mapsIdAttributeName = ToOneAttributeMapping.findMapsIdPropertyName(entityMappingType, this.referencedPropertyName);
                if (mapsIdAttributeName != null) {
                    HashSet<String> targetKeyPropertyNames2 = new HashSet<String>(2);
                    targetKeyPropertyNames2.add(this.targetKeyPropertyName);
                    ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames2, mapsIdAttributeName, entityMappingType.getEntityPersister().getIdentifierType(), declaringEntityPersister.getFactory());
                    this.targetKeyPropertyNames = targetKeyPropertyNames2;
                } else {
                    this.targetKeyPropertyNames = Collections.singleton(this.targetKeyPropertyName);
                }
            }
        }
    }

    private ToOneAttributeMapping(ToOneAttributeMapping original, ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        super(original.getAttributeName(), original.getStateArrayPosition(), original.getAttributeMetadataAccess(), original, declaringType, original.getPropertyAccess(), original.getValueGeneration());
        this.navigableRole = original.navigableRole;
        this.sqlAliasStem = original.sqlAliasStem;
        this.isNullable = original.isNullable;
        this.isKeyTableNullable = original.isKeyTableNullable;
        this.isOptional = original.isOptional;
        this.isIgnoreNotFound = original.isIgnoreNotFound;
        this.unwrapProxy = original.unwrapProxy;
        this.entityMappingType = original.entityMappingType;
        this.referencedPropertyName = original.referencedPropertyName;
        this.targetKeyPropertyName = original.targetKeyPropertyName;
        this.targetKeyPropertyNames = original.targetKeyPropertyNames;
        this.cardinality = original.cardinality;
        this.bidirectionalAttributeName = original.bidirectionalAttributeName;
        this.declaringTableGroupProducer = declaringTableGroupProducer;
        this.isConstrained = original.isConstrained;
    }

    private boolean equal(Iterator<Selectable> lhsColumns, Iterator<Selectable> rhsColumns) {
        boolean hasNext;
        do {
            Selectable lhs = lhsColumns.next();
            Selectable rhs = rhsColumns.next();
            if (!lhs.getText().equals(rhs.getText())) {
                return false;
            }
            hasNext = lhsColumns.hasNext();
            if (hasNext == rhsColumns.hasNext()) continue;
            return false;
        } while (hasNext);
        return true;
    }

    static String findMapsIdPropertyName(EntityMappingType entityMappingType, String referencedPropertyName) {
        AbstractEntityPersister persister = (AbstractEntityPersister)entityMappingType.getEntityPersister();
        if (Arrays.equals(persister.getKeyColumnNames(), persister.getPropertyColumnNames(referencedPropertyName))) {
            return persister.getIdentifierPropertyName();
        }
        return null;
    }

    static void addPrefixedPropertyNames(Set<String> targetKeyPropertyNames, String prefix, Type type, SessionFactoryImplementor factory) {
        if (prefix != null) {
            targetKeyPropertyNames.add(prefix);
        }
        if (type.isComponentType()) {
            ComponentType componentType = (ComponentType)type;
            String[] propertyNames = componentType.getPropertyNames();
            Type[] componentTypeSubtypes = componentType.getSubtypes();
            int propertyNamesLength = propertyNames.length;
            for (int i = 0; i < propertyNamesLength; ++i) {
                Object newPrefix = prefix == null ? propertyNames[i] : prefix + "." + propertyNames[i];
                ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, componentTypeSubtypes[i], factory);
            }
        } else if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(factory);
            String propertyName = entityType.isReferenceToPrimaryKey() ? entityType.getAssociatedEntityPersister(factory).getIdentifierPropertyName() : entityType.getRHSUniqueKeyPropertyName();
            Object newPrefix = prefix == null ? propertyName : (propertyName == null ? prefix : prefix + "." + propertyName);
            ToOneAttributeMapping.addPrefixedPropertyNames(targetKeyPropertyNames, (String)newPrefix, identifierOrUniqueKeyType, factory);
        }
    }

    public ToOneAttributeMapping copy(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer) {
        return new ToOneAttributeMapping(this, declaringType, declaringTableGroupProducer);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        assert (this.identifyingColumnsTableExpression != null);
        this.foreignKeyDescriptor = foreignKeyDescriptor;
        this.sideNature = this.cardinality == Cardinality.ONE_TO_ONE && this.bidirectionalAttributeName != null ? ForeignKeyDescriptor.Nature.TARGET : (foreignKeyDescriptor.getAssociationKey().getTable().equals(this.identifyingColumnsTableExpression) ? ForeignKeyDescriptor.Nature.KEY : ForeignKeyDescriptor.Nature.TARGET);
        this.canUseParentTableGroup = !this.isIgnoreNotFound && this.sideNature == ForeignKeyDescriptor.Nature.KEY && this.declaringTableGroupProducer.containsTableReference(this.identifyingColumnsTableExpression);
    }

    public void setIdentifyingColumnsTableExpression(String tableExpression) {
        this.identifyingColumnsTableExpression = tableExpression;
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return this.sideNature;
    }

    public boolean canJoinForeignKey(EntityIdentifierMapping identifierMapping) {
        return this.sideNature == ForeignKeyDescriptor.Nature.KEY && identifierMapping == this.getForeignKeyDescriptor().getTargetPart() && !this.isNullable;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public String getTargetKeyPropertyName() {
        return this.targetKeyPropertyName;
    }

    public Set<String> getTargetKeyPropertyNames() {
        return this.targetKeyPropertyNames;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public EntityMappingType getMappedType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType targetType) {
        if (this.canUseParentTableGroup && this.targetKeyPropertyNames.contains(name)) {
            ModelPart fkSideModelPart;
            ModelPart fkTargetModelPart;
            if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
                fkTargetModelPart = this.foreignKeyDescriptor.getTargetPart();
                fkSideModelPart = this.foreignKeyDescriptor.getKeyPart();
            } else {
                fkTargetModelPart = this.foreignKeyDescriptor.getKeyPart();
                fkSideModelPart = this.foreignKeyDescriptor.getTargetPart();
            }
            if (fkTargetModelPart instanceof NonAggregatedIdentifierMappingImpl) {
                return ((ModelPartContainer)fkSideModelPart).findSubPart(name, targetType);
            }
            return fkSideModelPart;
        }
        return EntityValuedFetchable.super.findSubPart(name, targetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        AssociationKey associationKey = this.foreignKeyDescriptor.getAssociationKey();
        if (creationState.isAssociationKeyVisited(associationKey) || this.bidirectionalAttributeName != null && !creationState.isRegisteringVisitedAssociationKeys()) {
            DomainResult<?> foreignKeyDomainResult;
            NavigablePath parentNavigablePath = fetchablePath.getParent();
            assert (parentNavigablePath.equals(fetchParent.getNavigablePath()));
            if (parentNavigablePath.getLocalName().equals("{fk}")) {
                return null;
            }
            ModelPart parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            if (parentModelPart instanceof EmbeddedIdentifierMappingImpl) {
                while (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
                    parentNavigablePath = parentNavigablePath.getParent();
                    assert (parentNavigablePath != null);
                    parentModelPart = creationState.resolveModelPart(parentNavigablePath);
                }
            }
            while (parentModelPart instanceof EmbeddableValuedFetchable) {
                parentNavigablePath = parentNavigablePath.getParent();
                assert (parentNavigablePath != null);
                parentModelPart = creationState.resolveModelPart(parentNavigablePath);
            }
            if (this.isBidirectionalAttributeName(parentNavigablePath, parentModelPart, fetchablePath, creationState)) {
                return this.createCircularBiDirectionalFetch(fetchablePath, fetchParent, parentNavigablePath, creationState);
            }
            TableGroup parentTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
            assert (!creationState.isResolvingCircularFetch());
            try {
                creationState.setResolvingCircularFetch(true);
                foreignKeyDomainResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, this.sideNature, creationState);
            }
            finally {
                creationState.setResolvingCircularFetch(false);
            }
            return new CircularFetchImpl(this, this.getEntityMappingType(), fetchTiming, fetchablePath, fetchParent, this, this.isSelectByUniqueKey(this.sideNature), fetchablePath, foreignKeyDomainResult);
        }
        return null;
    }

    protected boolean isBidirectionalAttributeName(NavigablePath parentNavigablePath, ModelPart parentModelPart, NavigablePath fetchablePath, DomainResultCreationState creationState) {
        if (this.bidirectionalAttributeName == null) {
            if (parentModelPart instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)parentModelPart;
                if (toOneAttributeMapping.bidirectionalAttributeName != null) {
                    return toOneAttributeMapping.isBidirectionalAttributeName(fetchablePath, this, parentNavigablePath, creationState);
                }
            } else {
                if (parentModelPart instanceof PluralAttributeMapping) {
                    return parentNavigablePath.getParent() != null && ((PluralAttributeMapping)parentModelPart).isBidirectionalAttributeName(fetchablePath, this);
                }
                if (parentModelPart instanceof EntityCollectionPart) {
                    NavigablePath parentOfParent = parentNavigablePath.getParent();
                    if (parentOfParent instanceof EntityIdentifierNavigablePath) {
                        parentOfParent = parentOfParent.getParent();
                    }
                    return parentOfParent.getParent() != null && ((PluralAttributeMapping)creationState.resolveModelPart(parentOfParent)).isBidirectionalAttributeName(fetchablePath, this);
                }
            }
            return false;
        }
        if (this.cardinality == Cardinality.MANY_TO_ONE) {
            NavigablePath grandparentNavigablePath = parentNavigablePath.getParent();
            if (parentNavigablePath.getUnaliasedLocalName().equals(CollectionPart.Nature.ELEMENT.getName()) && grandparentNavigablePath != null && grandparentNavigablePath.getUnaliasedLocalName().equals(this.bidirectionalAttributeName)) {
                NavigablePath parentPath = grandparentNavigablePath.getParent();
                if (parentPath == null) {
                    return grandparentNavigablePath.getFullPath().equals(this.entityMappingType.findSubPart(this.bidirectionalAttributeName).getNavigableRole().getFullPath());
                }
                if (parentPath.getParent() == null) {
                    String entityName = this.entityMappingType.getPartName();
                    return parentPath.getFullPath().startsWith(entityName) && (parentPath.getFullPath().length() == entityName.length() || parentPath.getFullPath().charAt(entityName.length()) == '(');
                }
                return parentPath.getUnaliasedLocalName().equals(this.navigableRole.getLocalName());
            }
            return false;
        }
        return parentNavigablePath.getUnaliasedLocalName().equals(this.bidirectionalAttributeName);
    }

    public String getBidirectionalAttributeName() {
        return this.bidirectionalAttributeName;
    }

    private Fetch createCircularBiDirectionalFetch(NavigablePath fetchablePath, FetchParent fetchParent, NavigablePath parentNavigablePath, DomainResultCreationState creationState) {
        boolean hasBidirectionalFetchParent;
        NavigablePath referencedNavigablePath;
        FetchParent realFetchParent = fetchParent;
        while (realFetchParent.getNavigablePath() != parentNavigablePath) {
            realFetchParent = ((Fetch)((Object)fetchParent)).getFetchParent();
        }
        if (parentNavigablePath.getParent() == null) {
            referencedNavigablePath = parentNavigablePath;
            hasBidirectionalFetchParent = true;
        } else if (CollectionPart.Nature.fromNameExact(parentNavigablePath.getUnaliasedLocalName()) != null) {
            referencedNavigablePath = parentNavigablePath.getParent().getParent();
            hasBidirectionalFetchParent = fetchParent instanceof Fetch && ((Fetch)((Object)fetchParent)).getFetchParent() instanceof Fetch;
        } else {
            referencedNavigablePath = parentNavigablePath.getParent();
            hasBidirectionalFetchParent = fetchParent instanceof Fetch;
        }
        if (referencedNavigablePath != null) {
            if (hasBidirectionalFetchParent) {
                DomainResult<?> keyDomainResult = this.sideNature == ForeignKeyDescriptor.Nature.KEY && !this.isKeyTableNullable ? this.foreignKeyDescriptor.createKeyDomainResult(fetchablePath, creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(realFetchParent.getNavigablePath()), creationState) : null;
                return new CircularBiDirectionalFetchImpl(FetchTiming.IMMEDIATE, fetchablePath, fetchParent, this, LockMode.READ, referencedNavigablePath, keyDomainResult);
            }
            FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
            TableGroup tableGroup = fromClauseAccess.getTableGroup(referencedNavigablePath);
            fromClauseAccess.registerTableGroup(fetchablePath, tableGroup);
            return new EntityFetchJoinedImpl(fetchParent, this, tableGroup, false, fetchablePath, creationState);
        }
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        NavigablePath realParent = CollectionPart.Nature.fromNameExact(parentNavigablePath.getUnaliasedLocalName()) != null ? parentNavigablePath.getParent() : parentNavigablePath;
        TableGroup tableGroup = fromClauseAccess.getTableGroup(realParent);
        return new EntityDelayedFetchImpl(fetchParent, this, fetchablePath, this.foreignKeyDescriptor.createDomainResult(fetchablePath, tableGroup, this.sideNature, creationState), this.isSelectByUniqueKey(this.sideNature));
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup parentTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
        NavigablePath parentNavigablePath = fetchablePath.getParent();
        assert (parentNavigablePath.equals(fetchParent.getNavigablePath()) || fetchParent.getNavigablePath() instanceof TreatedNavigablePath && parentNavigablePath.equals(fetchParent.getNavigablePath().getRealParent()));
        if (fetchTiming == FetchTiming.IMMEDIATE && selected) {
            ToOneAttributeMapping bidirectionalAttribute;
            AssociationKey secondKey;
            ModelPart bidirectionalModelPart;
            TableGroup tableGroup;
            if (fetchParent instanceof EntityResultJoinedSubclassImpl && ((EntityPersister)fetchParent.getReferencedModePart()).findDeclaredAttributeMapping(this.getPartName()) == null) {
                TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, resultVariable, this.getJoinType(fetchablePath, parentTableGroup), true, false, creationState.getSqlAstCreationState());
                parentTableGroup.addTableGroupJoin(tableGroupJoin);
                tableGroup = tableGroupJoin.getJoinedGroup();
                fromClauseAccess.registerTableGroup(fetchablePath, tableGroup);
            } else {
                tableGroup = fromClauseAccess.resolveTableGroup(fetchablePath, np -> {
                    TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, resultVariable, this.getDefaultSqlAstJoinType(parentTableGroup), true, false, creationState.getSqlAstCreationState());
                    parentTableGroup.addTableGroupJoin(tableGroupJoin);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
            boolean added = creationState.registerVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
            AssociationKey additionalAssociationKey = null;
            if (this.cardinality == Cardinality.LOGICAL_ONE_TO_ONE && this.bidirectionalAttributeName != null && (bidirectionalModelPart = this.entityMappingType.findSubPart(this.bidirectionalAttributeName)) instanceof ToOneAttributeMapping && creationState.registerVisitedAssociationKey(secondKey = (bidirectionalAttribute = (ToOneAttributeMapping)bidirectionalModelPart).getForeignKeyDescriptor().getAssociationKey())) {
                additionalAssociationKey = secondKey;
            }
            EntityFetchJoinedImpl entityFetchJoined = new EntityFetchJoinedImpl(fetchParent, this, tableGroup, true, fetchablePath, creationState);
            if (added) {
                creationState.removeVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
            }
            if (additionalAssociationKey != null) {
                creationState.removeVisitedAssociationKey(additionalAssociationKey);
            }
            return entityFetchJoined;
        }
        ForeignKeyDescriptor.Nature resolvingKeySideOfForeignKey = creationState.getCurrentlyResolvingForeignKeyPart();
        ForeignKeyDescriptor.Nature side = resolvingKeySideOfForeignKey == ForeignKeyDescriptor.Nature.KEY && this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? ForeignKeyDescriptor.Nature.KEY : this.sideNature;
        DomainResult<?> keyResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, side, creationState);
        boolean selectByUniqueKey = this.isSelectByUniqueKey(side);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return new EntityFetchSelectImpl(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey, creationState);
        }
        return new EntityDelayedFetchImpl(fetchParent, this, fetchablePath, keyResult, selectByUniqueKey);
    }

    private boolean isSelectByUniqueKey(ForeignKeyDescriptor.Nature side) {
        if (side == ForeignKeyDescriptor.Nature.KEY) {
            return !this.foreignKeyDescriptor.getNavigableRole().equals(this.entityMappingType.getIdentifierMapping().getNavigableRole());
        }
        return this.bidirectionalAttributeName != null && !this.targetKeyPropertyNames.contains(this.entityMappingType.getEntityPersister().getEntityMetamodel().getIdentifierProperty().getName());
    }

    @Override
    public <T> DomainResult<T> createDelayedDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.TARGET || this.referencedPropertyName != null) {
            creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(navigablePath, np -> {
                TableGroupJoin tableGroupJoin = this.createTableGroupJoin(navigablePath, tableGroup, null, this.getDefaultSqlAstJoinType(tableGroup), true, false, creationState.getSqlAstCreationState());
                tableGroup.addTableGroupJoin(tableGroupJoin);
                return tableGroupJoin.getJoinedGroup();
            });
        }
        if (this.referencedPropertyName == null) {
            return new EntityDelayedResultImpl(navigablePath.append("{id}"), this, tableGroup, creationState);
        }
        EntityResultImpl entityResult = new EntityResultImpl(navigablePath, this, tableGroup, null, creationState);
        entityResult.afterInitialize(entityResult, creationState);
        return entityResult;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        Class<?> parentTableGroupType;
        Class<?> attributeDeclaringType;
        if (this.isKeyTableNullable || this.isNullable) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.getModelPart() instanceof CollectionPart) {
            return SqlAstJoinType.LEFT;
        }
        if (parentTableGroup.canUseInnerJoins() && (attributeDeclaringType = this.declaringTableGroupProducer.getJavaTypeDescriptor().getJavaTypeClass()).isAssignableFrom(parentTableGroupType = parentTableGroup.getModelPart().getJavaTypeDescriptor().getJavaTypeClass())) {
            return SqlAstJoinType.INNER;
        }
        return SqlAstJoinType.LEFT;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        PluralTableGroup pluralTableGroup;
        String indexPropertyName;
        String pathName;
        assert (!(lhs instanceof PluralTableGroup));
        TableGroup parentTableGroup = lhs;
        ModelPartContainer parentContainer = lhs.getModelPart();
        StringBuilder embeddablePathSb = null;
        while (!(parentContainer instanceof CollectionPart) && parentContainer instanceof EmbeddableValuedModelPart) {
            if (embeddablePathSb == null) {
                embeddablePathSb = new StringBuilder();
            }
            embeddablePathSb.insert(0, parentContainer.getPartName() + ".");
            parentTableGroup = fromClauseAccess.findTableGroup(parentTableGroup.getNavigablePath().getParent());
            parentContainer = parentTableGroup.getModelPart();
        }
        if (CollectionPart.Nature.ELEMENT.getName().equals(parentTableGroup.getNavigablePath().getUnaliasedLocalName()) && !addsPredicate && (sqlAstJoinType == SqlAstJoinType.INNER || sqlAstJoinType == SqlAstJoinType.LEFT) && (pathName = embeddablePathSb != null ? embeddablePathSb.append(this.getAttributeName()).toString() : this.getAttributeName()).equals(indexPropertyName = (pluralTableGroup = (PluralTableGroup)fromClauseAccess.findTableGroup(parentTableGroup.getNavigablePath().getParent())).getModelPart().getIndexMetadata().getIndexPropertyName())) {
            TableGroup indexTableGroup = pluralTableGroup.getIndexTableGroup();
            this.initializeIfNeeded(lhs, sqlAstJoinType, indexTableGroup);
            return new TableGroupJoin(navigablePath, sqlAstJoinType, new MappedByTableGroup(navigablePath, this, indexTableGroup, fetched, pluralTableGroup, (np, tableExpression) -> {
                if (!this.canUseParentTableGroup) {
                    return false;
                }
                NavigablePath path = np.getParent();
                if (path != null && navigablePath.equals(path)) {
                    return this.targetKeyPropertyNames.contains(np.getUnaliasedLocalName()) && this.identifyingColumnsTableExpression.equals(tableExpression);
                }
                StringBuilder sb = new StringBuilder(np.getFullPath().length());
                sb.append(np.getUnaliasedLocalName());
                while (path != null && !navigablePath.equals(path)) {
                    sb.insert(0, '.');
                    sb.insert(0, path.getUnaliasedLocalName());
                    path = path.getParent();
                }
                return path != null && navigablePath.equals(path) && this.targetKeyPropertyNames.contains(sb.toString()) && this.identifyingColumnsTableExpression.equals(tableExpression);
            }), null);
        }
        TableGroup lazyTableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, fetched, (Consumer)null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        TableGroupJoin join = new TableGroupJoin(navigablePath, sqlAstJoinType, lazyTableGroup, null);
        TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this.identifyingColumnsTableExpression);
        ((LazyTableGroup)lazyTableGroup).setTableGroupInitializerCallback(tableGroup -> join.applyPredicate(this.foreignKeyDescriptor.generateJoinPredicate(this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? lhsTableReference : tableGroup.getPrimaryTableReference(), this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? tableGroup.getPrimaryTableReference() : lhsTableReference, sqlAstJoinType, sqlExpressionResolver, creationContext)));
        this.initializeIfNeeded(lhs, sqlAstJoinType, lazyTableGroup);
        return join;
    }

    @Override
    public LazyTableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(this.sqlAliasStem);
        boolean canUseInnerJoin = sqlAstJoinType == SqlAstJoinType.INNER || lhs.canUseInnerJoins() && !this.isNullable;
        LazyTableGroup lazyTableGroup = new LazyTableGroup(canUseInnerJoin, navigablePath, fetched, () -> this.createTableGroupInternal(canUseInnerJoin, navigablePath, fetched, null, sqlAliasBase, sqlExpressionResolver, creationContext), (np, tableExpression) -> {
            if (!this.canUseParentTableGroup) {
                return false;
            }
            NavigablePath path = np.getParent();
            if (path != null && navigablePath.equals(path)) {
                return this.targetKeyPropertyNames.contains(np.getUnaliasedLocalName()) && this.identifyingColumnsTableExpression.equals(tableExpression);
            }
            StringBuilder sb = new StringBuilder(np.getFullPath().length());
            sb.append(np.getUnaliasedLocalName());
            while (path != null && !navigablePath.equals(path)) {
                sb.insert(0, '.');
                sb.insert(0, path.getUnaliasedLocalName());
                path = path.getParent();
            }
            return path != null && navigablePath.equals(path) && this.targetKeyPropertyNames.contains(sb.toString()) && this.identifyingColumnsTableExpression.equals(tableExpression);
        }, this, explicitSourceAlias, sqlAliasBase, creationContext.getSessionFactory(), lhs);
        if (predicateConsumer != null) {
            TableReference lhsTableReference = lhs.resolveTableReference(navigablePath, this.identifyingColumnsTableExpression);
            lazyTableGroup.setTableGroupInitializerCallback(tableGroup -> predicateConsumer.accept(this.foreignKeyDescriptor.generateJoinPredicate(this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? lhsTableReference : tableGroup.getPrimaryTableReference(), this.sideNature == ForeignKeyDescriptor.Nature.TARGET ? tableGroup.getPrimaryTableReference() : lhsTableReference, sqlAstJoinType, sqlExpressionResolver, creationContext)));
            this.initializeIfNeeded(lhs, sqlAstJoinType, lazyTableGroup);
        }
        return lazyTableGroup;
    }

    private void initializeIfNeeded(TableGroup lhs, SqlAstJoinType sqlAstJoinType, TableGroup tableGroup) {
        if (sqlAstJoinType == SqlAstJoinType.INNER && (this.isNullable || !lhs.canUseInnerJoins())) {
            tableGroup.getPrimaryTableReference();
        }
    }

    private SqlAstJoinType getJoinType(NavigablePath navigablePath, TableGroup tableGroup) {
        for (TableGroupJoin tableGroupJoin : tableGroup.getTableGroupJoins()) {
            if (!tableGroupJoin.getNavigablePath().equals(navigablePath)) continue;
            return tableGroupJoin.getJoinType();
        }
        return this.getDefaultSqlAstJoinType(tableGroup);
    }

    public TableGroup createTableGroupInternal(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, false, sqlAliasBase, tableExpression -> this.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    public boolean isIgnoreNotFound() {
        return this.isIgnoreNotFound;
    }

    @Override
    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.foreignKeyDescriptor.getPart(this.sideNature);
    }

    public String toString() {
        return "ToOneAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.foreignKeyDescriptor.breakDownJdbcValues(this.foreignKeyDescriptor.getAssociationKeyFromSide(domainValue, this.sideNature.inverse(), session), valueConsumer, session);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            return this.foreignKeyDescriptor.visitKeySelectables(offset, consumer);
        }
        return 0;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        if (this.sideNature == ForeignKeyDescriptor.Nature.KEY) {
            this.foreignKeyDescriptor.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }
    }

    @Override
    public int getJdbcTypeCount() {
        return this.foreignKeyDescriptor.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.foreignKeyDescriptor.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(this.foreignKeyDescriptor.disassemble(this.foreignKeyDescriptor.getAssociationKeyFromSide(value, this.sideNature.inverse(), session), session), clause, offset, consumer, session);
    }

    public static enum Cardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        LOGICAL_ONE_TO_ONE;

    }
}

