/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Supplier;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.EmbeddableInstantiator;
import org.hibernate.metamodel.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaType;

public class VirtualIdRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final EntityMappingType entityMappingType;
    private final EmbeddableInstantiator instantiator;

    public VirtualIdRepresentationStrategy(VirtualIdEmbeddable virtualIdEmbeddable, EntityMappingType entityMappingType) {
        this.entityMappingType = entityMappingType;
        this.instantiator = new InstantiatorAdapter(virtualIdEmbeddable, entityMappingType);
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public JavaType<?> getMappedJavaTypeDescriptor() {
        return this.entityMappingType.getMappedJavaTypeDescriptor();
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(this.entityMappingType.getMappedJavaTypeDescriptor().getJavaTypeClass(), bootAttributeDescriptor.getName());
    }

    private static class InstantiatorAdapter
    implements StandardEmbeddableInstantiator {
        private final VirtualIdEmbeddable virtualIdEmbeddable;
        private final EntityInstantiator entityInstantiator;

        public InstantiatorAdapter(VirtualIdEmbeddable virtualIdEmbeddable, EntityMappingType entityMappingType) {
            this.virtualIdEmbeddable = virtualIdEmbeddable;
            this.entityInstantiator = entityMappingType.getRepresentationStrategy().getInstantiator();
        }

        @Override
        public Object instantiate(Supplier<Object[]> valuesAccess, SessionFactoryImplementor sessionFactory) {
            Object[] values;
            Object instantiated = this.entityInstantiator.instantiate(sessionFactory);
            if (valuesAccess != null && (values = valuesAccess.get()) != null) {
                this.virtualIdEmbeddable.setValues(instantiated, values);
            }
            return instantiated;
        }

        @Override
        public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
            return this.entityInstantiator.isInstance(object, sessionFactory);
        }

        @Override
        public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
            return this.entityInstantiator.isSameClass(object, sessionFactory);
        }
    }
}

