/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortOrder;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class SelfRenderingOrderingExpression
implements OrderingExpression,
SelfRenderingExpression {
    private final String expression;

    public SelfRenderingOrderingExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return null;
    }

    @Override
    public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
        sqlAppender.append(this.expression);
    }

    @Override
    public Expression resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        return this;
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        Expression expression = this.resolve(ast, tableGroup, modelPartName, creationState);
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        ast.addSortSpecification(new SortSpecification(expression, collation, sortOrder, nullPrecedence));
    }
}

