/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPath;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class DiscriminatorSqmPathSource<D>
extends AbstractSqmPathSource<D>
implements AllowableParameterType<D>,
AllowableFunctionReturnType<D> {
    private final EntityDomainType<?> entityDomainType;
    private final EntityMappingType entityMapping;

    public DiscriminatorSqmPathSource(DomainType<D> discriminatorValueType, EntityDomainType<?> entityDomainType, EntityMappingType entityMapping) {
        super("{discriminator}", discriminatorValueType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
        this.entityDomainType = entityDomainType;
        this.entityMapping = entityMapping;
    }

    @Override
    public SqmPath<D> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return new DiscriminatorSqmPath(this, lhs, this.entityDomainType, this.entityMapping, lhs.nodeBuilder());
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalStateException("Entity discriminator cannot be de-referenced");
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Class<D> getJavaType() {
        return this.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }
}

