/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class EmbeddedSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements CompositeSqmPathSource<J>,
AllowableParameterType<J> {
    public EmbeddedSqmPathSource(String localPathName, EmbeddableDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, domainType, jpaBindableType);
    }

    @Override
    public EmbeddableDomainType<J> getSqmPathType() {
        return (EmbeddableDomainType)super.getSqmPathType();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    public Class<J> getJavaType() {
        return this.getBindableJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return (SqmPathSource)((Object)this.getSqmPathType().findAttribute(name));
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmEmbeddedValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
    }
}

