/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import java.util.List;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractPluralAttribute;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;

class ListAttributeImpl<X, E>
extends AbstractPluralAttribute<X, List<E>, E>
implements ListPersistentAttribute<X, E> {
    private final SqmPathSource<Integer> indexPathSource;

    ListAttributeImpl(PluralAttributeBuilder<X, List<E>, E, ?> builder, MetadataContext metadataContext) {
        super(builder, metadataContext);
        this.indexPathSource = SqmMappingModelHelper.resolveSqmKeyPathSource(builder.getListIndexOrMapKeyType(), Bindable.BindableType.PLURAL_ATTRIBUTE);
    }

    @Override
    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.LIST;
    }

    @Override
    public SqmPathSource<Integer> getIndexPathSource() {
        return this.indexPathSource;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromNameExact(name);
        if (nature != null) {
            switch (nature) {
                case INDEX: {
                    return this.indexPathSource;
                }
                case ELEMENT: {
                    return this.getElementPathSource();
                }
            }
        }
        return this.getElementPathSource().findSubPathSource(name);
    }

    @Override
    public SqmPathSource<?> getIntermediatePathSource(SqmPathSource<?> pathSource) {
        return pathSource == this.getElementPathSource() || pathSource == this.indexPathSource ? null : this.getElementPathSource();
    }

    @Override
    public SqmAttributeJoin createSqmJoin(SqmFrom lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        return new SqmListJoin(lhs, this, alias, joinType, fetched, creationState.getCreationContext().getNodeBuilder());
    }
}

