/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;

public abstract class AbstractStandardCallableStatementSupport
implements CallableStatementSupport {
    @Override
    public void registerParameters(String procedureName, ProcedureCallImplementor procedureCall, CallableStatement statement, ParameterStrategy parameterStrategy, ProcedureParameterMetadataImplementor parameterMetadata, SharedSessionContractImplementor session) {
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        RefCursorSupport refCursorSupport = procedureCall.getSession().getFactory().getServiceRegistry().getService(RefCursorSupport.class);
        try {
            for (int i = 0; i < registrations.size(); ++i) {
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    if (procedureCall.getParameterStrategy() == ParameterStrategy.NAMED) {
                        refCursorSupport.registerRefCursorParameter(statement, parameter.getName());
                        continue;
                    }
                    refCursorSupport.registerRefCursorParameter(statement, parameter.getPosition());
                    continue;
                }
                parameter.prepare(statement, i + 1, procedureCall);
            }
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Error registering CallableStatement parameters", procedureName);
        }
    }
}

