/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.AllowableOutputParameterType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.sql.exec.internal.JdbcCallFunctionReturnImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class FunctionReturnImpl
implements FunctionReturnImplementor {
    private final ProcedureCallImplementor procedureCall;
    private int jdbcTypeCode;
    private AllowableOutputParameterType<?> ormType;

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, int jdbcTypeCode) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor procedureCall, AllowableOutputParameterType ormType) {
        this.procedureCall = procedureCall;
        this.jdbcTypeCode = ormType.getJdbcTypeDescriptor().getJdbcTypeCode();
        this.ormType = ormType;
    }

    public JdbcCallFunctionReturn toJdbcFunctionReturn(SharedSessionContractImplementor persistenceContext) {
        JdbcCallParameterExtractorImpl parameterExtractor;
        BasicType<?> ormType;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        if (this.getJdbcTypeCode() == 2012) {
            refCursorExtractor = new JdbcCallRefCursorExtractorImpl(null, 0);
            ormType = null;
            parameterExtractor = null;
        } else {
            TypeConfiguration typeConfiguration = persistenceContext.getFactory().getMetamodel().getTypeConfiguration();
            JdbcType sqlTypeDescriptor = typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(this.getJdbcTypeCode());
            BasicJavaType javaTypeMapping = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
            ormType = typeConfiguration.standardBasicTypeForJavaType(javaTypeMapping.getJavaType().getClass());
            parameterExtractor = new JdbcCallParameterExtractorImpl(this.procedureCall.getProcedureName(), null, 0, ormType);
            refCursorExtractor = null;
        }
        return new JdbcCallFunctionReturnImpl(this.getJdbcTypeCode(), ormType, parameterExtractor, refCursorExtractor);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    @Override
    public AllowableParameterType getHibernateType() {
        return this.ormType;
    }

    public String getName() {
        return null;
    }

    public Integer getPosition() {
        return 0;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    public Class getParameterType() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public void applyAnticipatedType(AllowableParameterType type) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.ormType != null) {
                return new FunctionReturnImpl(this.procedureCall, this.ormType);
            }
            return new FunctionReturnImpl(this.procedureCall, this.jdbcTypeCode);
        };
    }
}

