/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.FunctionReturnImpl;
import org.hibernate.procedure.internal.NamedCallableQueryMementoImpl;
import org.hibernate.procedure.internal.ProcedureOutputsImpl;
import org.hibernate.procedure.internal.ProcedureParamBindings;
import org.hibernate.procedure.internal.ProcedureParameterImpl;
import org.hibernate.procedure.internal.ProcedureParameterMetadataImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.ResultSetMappingImpl;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.result.NoMoreReturnsException;
import org.hibernate.result.Output;
import org.hibernate.result.ResultSetOutput;
import org.hibernate.result.UpdateCountOutput;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.sql.exec.spi.JdbcCall;
import org.hibernate.sql.results.NoMoreOutputsException;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.jboss.logging.Logger;

public class ProcedureCallImpl<R>
extends AbstractQuery<R>
implements ProcedureCallImplementor<R>,
ResultContext {
    private static final Logger LOG = Logger.getLogger(ProcedureCallImpl.class);
    private final String procedureName;
    private FunctionReturnImpl functionReturn;
    private final ProcedureParameterMetadataImpl parameterMetadata;
    private final ProcedureParamBindings paramBindings;
    private final ResultSetMapping resultSetMapping;
    private Set<String> synchronizedQuerySpaces;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private ProcedureOutputsImpl outputs;
    private ProcedureOutputs procedureResult;

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName) {
        super(session);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.resultSetMapping = new ResultSetMappingImpl(procedureName);
        this.synchronizedQuerySpaces = null;
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, Class ... resultClasses) {
        super(session);
        assert (resultClasses != null && resultClasses.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = new HashSet<String>();
        String mappingId = procedureName + ":" + StringHelper.join(",", resultClasses);
        this.resultSetMapping = new ResultSetMappingImpl(mappingId);
        Util.resolveResultSetMappingClasses(resultClasses, this.resultSetMapping, this.synchronizedQuerySpaces::add, () -> this.getSession().getFactory());
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, String procedureName, String ... resultSetMappingNames) {
        super(session);
        assert (resultSetMappingNames != null && resultSetMappingNames.length > 0);
        this.procedureName = procedureName;
        this.parameterMetadata = new ProcedureParameterMetadataImpl();
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = new HashSet<String>();
        String mappingId = procedureName + ":" + StringHelper.join(",", resultSetMappingNames);
        this.resultSetMapping = new ResultSetMappingImpl(mappingId);
        Util.resolveResultSetMappingNames(resultSetMappingNames, this.resultSetMapping, this.synchronizedQuerySpaces::add, () -> this.getSession().getFactory());
    }

    ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMemento memento) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        this.resultSetMapping = new ResultSetMappingImpl(memento.getRegistrationName());
        Util.resolveResultSetMappings(memento.getResultSetMappingNames(), memento.getResultSetMappingClasses(), this.resultSetMapping, this.synchronizedQuerySpaces::add, () -> this.getSession().getFactory());
        this.applyOptions(memento);
    }

    ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMemento memento, Class<?> ... resultTypes) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        String mappingId = this.procedureName + ":" + StringHelper.join(",", resultTypes);
        this.resultSetMapping = new ResultSetMappingImpl(mappingId);
        Util.resolveResultSetMappings(null, resultTypes, this.resultSetMapping, this.synchronizedQuerySpaces::add, () -> this.getSession().getFactory());
        this.applyOptions(memento);
    }

    public ProcedureCallImpl(SharedSessionContractImplementor session, NamedCallableQueryMementoImpl memento, String ... resultSetMappingNames) {
        super(session);
        this.procedureName = memento.getCallableName();
        this.parameterMetadata = new ProcedureParameterMetadataImpl(memento, session);
        this.paramBindings = new ProcedureParamBindings(this.parameterMetadata, this.getSessionFactory());
        this.synchronizedQuerySpaces = CollectionHelper.makeCopy(memento.getQuerySpaces());
        String mappingId = this.procedureName + ":" + StringHelper.join(",", resultSetMappingNames);
        this.resultSetMapping = new ResultSetMappingImpl(mappingId);
        Util.resolveResultSetMappings(resultSetMappingNames, null, this.resultSetMapping, this.synchronizedQuerySpaces::add, () -> this.getSession().getFactory());
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public QueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        throw new IllegalStateException("Cannot set LockMode on a procedure-call");
    }

    @Override
    public ProcedureParameterMetadataImpl getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.paramBindings;
    }

    @Override
    public ParameterStrategy getParameterStrategy() {
        return this.getParameterMetadata().getParameterStrategy();
    }

    @Override
    public boolean isFunctionCall() {
        return this.functionReturn != null;
    }

    @Override
    public ProcedureCall markAsFunctionCall(int sqlType) {
        this.functionReturn = new FunctionReturnImpl((ProcedureCallImplementor)this, sqlType);
        return this;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.paramBindings;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(parameterName, type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(int position, BasicTypeReference<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(position, type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> registerStoredProcedureParameter(String parameterName, BasicTypeReference<?> type, ParameterMode mode) {
        this.getSession().checkOpen(true);
        try {
            this.registerParameter(parameterName, (BasicTypeReference)type, mode);
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
        return this;
    }

    @Override
    public <T> ProcedureParameter<T> registerParameter(int position, Class<T> javaType, ParameterMode mode) {
        AllowableParameterType<T> parameterType = this.getSessionFactory().getDomainModel().resolveQueryParameterType(javaType);
        ProcedureParameterImpl<T> procedureParameter = new ProcedureParameterImpl<T>(position, mode, parameterType == null ? javaType : parameterType.getJavaType(), parameterType);
        this.registerParameter(procedureParameter);
        return procedureParameter;
    }

    @Override
    public <T> ProcedureParameter<T> registerParameter(int position, BasicTypeReference<T> typeReference, ParameterMode mode) {
        BasicType<T> basicType = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().resolve(typeReference);
        ProcedureParameterImpl<T> procedureParameter = new ProcedureParameterImpl<T>(position, mode, basicType.getJavaType(), basicType);
        this.registerParameter(procedureParameter);
        return procedureParameter;
    }

    private void registerParameter(ProcedureParameterImplementor parameter) {
        this.getParameterMetadata().registerParameter(parameter);
    }

    @Override
    public ProcedureParameterImplementor getParameterRegistration(int position) {
        return this.getParameterMetadata().getQueryParameter(position);
    }

    public <T> ProcedureParameterImplementor<T> registerParameter(String name, Class<T> javaType, ParameterMode mode) {
        AllowableParameterType<T> parameterType = this.getSessionFactory().getDomainModel().resolveQueryParameterType(javaType);
        ProcedureParameterImpl<T> parameter = new ProcedureParameterImpl<T>(name, mode, parameterType.getJavaType(), parameterType);
        this.registerParameter(parameter);
        return parameter;
    }

    public <T> ProcedureParameterImplementor<T> registerParameter(String name, BasicTypeReference<T> typeReference, ParameterMode mode) {
        BasicType<T> basicType = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().resolve(typeReference);
        ProcedureParameterImpl<T> parameter = new ProcedureParameterImpl<T>(name, mode, basicType.getJavaType(), basicType);
        this.registerParameter(parameter);
        return parameter;
    }

    @Override
    public ProcedureParameterImplementor getParameterRegistration(String name) {
        return this.getParameterMetadata().getQueryParameter(name);
    }

    public List getRegisteredParameters() {
        return this.getParameterMetadata().getRegistrationsAsList();
    }

    @Override
    public ProcedureOutputs getOutputs() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureOutputsImpl buildOutputs() {
        CallableStatementSupport callableStatementSupport = this.getSession().getJdbcServices().getJdbcEnvironment().getDialect().getCallableStatementSupport();
        ProcedureParameterMetadataImpl parameterMetadata = this.getParameterMetadata();
        JdbcCall call = callableStatementSupport.interpretCall(this.procedureName, this.functionReturn, parameterMetadata, this.paramBindings, this.getSession());
        LOG.debugf("Preparing procedure call : %s", (Object)call);
        CallableStatement statement = (CallableStatement)this.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement(call.getSql(), true);
        callableStatementSupport.registerParameters(this.procedureName, this, statement, parameterMetadata.getParameterStrategy(), parameterMetadata, this.getSession());
        return new ProcedureOutputsImpl(this, statement);
    }

    @Override
    public String getQueryString() {
        return null;
    }

    protected Set<String> synchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            this.synchronizedQuerySpaces = new HashSet<String>();
        }
        return this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityName(String entityName) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityName));
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityPersister persister) {
        this.synchronizedQuerySpaces().addAll(Arrays.asList((String[])persister.getQuerySpaces()));
    }

    @Override
    public ProcedureCallImplementor<R> addSynchronizedEntityClass(Class entityClass) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityClass.getName()));
        return this;
    }

    public ProcedureParameterImplementor[] collectRefCursorParameters() {
        ArrayList refCursorParams = new ArrayList();
        this.getParameterMetadata().visitRegistrations(queryParameter -> {
            ProcedureParameterImplementor registration = (ProcedureParameterImplementor)queryParameter;
            if (registration.getMode() == ParameterMode.REF_CURSOR) {
                refCursorParams.add(registration);
            }
        });
        return refCursorParams.toArray(new ProcedureParameterImplementor[0]);
    }

    @Override
    public NamedCallableQueryMemento toMemento(String name) {
        return new NamedCallableQueryMementoImpl(name, this.procedureName, this.getParameterStrategy(), ProcedureCallImpl.toParameterMementos(this.parameterMetadata), null, null, (Set<String>)this.getSynchronizedQuerySpaces(), this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    private static List<NamedCallableQueryMemento.ParameterMemento> toParameterMementos(ProcedureParameterMetadataImpl parameterMetadata) {
        if (parameterMetadata.getParameterStrategy() == ParameterStrategy.UNKNOWN) {
            return Collections.emptyList();
        }
        ArrayList<NamedCallableQueryMemento.ParameterMemento> mementos = new ArrayList<NamedCallableQueryMemento.ParameterMemento>();
        parameterMetadata.visitRegistrations(queryParameter -> {
            ProcedureParameterImplementor procedureParameter = (ProcedureParameterImplementor)queryParameter;
            mementos.add(new NamedCallableQueryMementoImpl.ParameterMementoImpl(procedureParameter.getPosition(), procedureParameter.getName(), procedureParameter.getMode(), procedureParameter.getParameterType(), procedureParameter.getHibernateType()));
        });
        return mementos;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        throw new IllegalStateException("EntityGraph hints are not supported for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public Query<R> applyGraph(RootGraph<?> graph, GraphSemantic semantic) {
        throw new IllegalStateException("EntityGraph hints are not supported for ProcedureCall/StoredProcedureQuery");
    }

    public boolean execute() {
        try {
            Output rtn = this.outputs().getCurrent();
            return ResultSetOutput.class.isInstance(rtn);
        }
        catch (NoMoreOutputsException e) {
            return false;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    protected ProcedureOutputs outputs() {
        if (this.procedureResult == null) {
            this.procedureResult = this.getOutputs();
        }
        return this.procedureResult;
    }

    @Override
    protected int doExecuteUpdate() {
        if (!this.getSession().isTransactionInProgress()) {
            throw new TransactionRequiredException("jakarta.persistence.Query.executeUpdate requires active transaction");
        }
        try {
            this.execute();
            int n = this.getUpdateCount();
            return n;
        }
        finally {
            this.outputs().release();
        }
    }

    public Object getOutputParameterValue(int position) {
        try {
            return this.outputs().getOutputParameterValue(position);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Object getOutputParameterValue(String parameterName) {
        try {
            return this.outputs().getOutputParameterValue(parameterName);
        }
        catch (ParameterStrategyException e) {
            throw new IllegalArgumentException("Invalid mix of named and positional parameters", (Throwable)((Object)e));
        }
        catch (NoSuchParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public boolean hasMoreResults() {
        return this.outputs().goToNext() && ResultSetOutput.class.isInstance(this.outputs().getCurrent());
    }

    public int getUpdateCount() {
        try {
            Output rtn = this.outputs().getCurrent();
            if (rtn == null) {
                return -1;
            }
            if (UpdateCountOutput.class.isInstance(rtn)) {
                return ((UpdateCountOutput)rtn).getUpdateCount();
            }
            return -1;
        }
        catch (NoMoreOutputsException e) {
            return -1;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    protected List<R> doList() {
        if (this.getMaxResults() == 0) {
            return Collections.emptyList();
        }
        try {
            Output rtn = this.outputs().getCurrent();
            if (!ResultSetOutput.class.isInstance(rtn)) {
                throw new IllegalStateException("Current CallableStatement ou was not a ResultSet, but getResultList was called");
            }
            return ((ResultSetOutput)rtn).getResultList();
        }
        catch (NoMoreOutputsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        throw new UnsupportedOperationException("Query#scroll is not valid for ProcedureCall/StoredProcedureQuery");
    }

    @Override
    public List<R> getResultList() {
        if (this.getMaxResults() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            Output rtn = this.outputs().getCurrent();
            if (!(rtn instanceof ResultSetOutput)) {
                throw new IllegalStateException("Current CallableStatement ou was not a ResultSet, but getResultList was called");
            }
            return ((ResultSetOutput)rtn).getResultList();
        }
        catch (NoMoreReturnsException e) {
            return null;
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he);
        }
        catch (RuntimeException e) {
            this.getSession().markForRollbackOnly();
            throw e;
        }
    }

    @Override
    public R getSingleResult() {
        List<R> resultList = this.getResultList();
        if (resultList == null || resultList.isEmpty()) {
            throw new NoResultException(String.format("Call to stored procedure [%s] returned no results", this.getProcedureName()));
        }
        if (resultList.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", this.getProcedureName()));
        }
        return resultList.get(0);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this)) {
            return (T)this;
        }
        if (cls.isInstance(this.parameterMetadata)) {
            return (T)this.parameterMetadata;
        }
        if (cls.isInstance(this.paramBindings)) {
            return (T)this.paramBindings;
        }
        if (cls.isInstance(this.queryOptions)) {
            return (T)this.queryOptions;
        }
        if (cls.isInstance(this.getSession())) {
            return (T)this.getSession();
        }
        if (ProcedureOutputs.class.isAssignableFrom(cls)) {
            return (T)this.getOutputs();
        }
        throw new PersistenceException("Unrecognized unwrap type : " + cls.getName());
    }

    @Override
    public ProcedureCallImplementor<R> setLockMode(LockModeType lockMode) {
        throw new IllegalStateException("jakarta.persistence.Query.setLockMode not valid on jakarta.persistence.StoredProcedureQuery");
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("jakarta.persistence.Query.getHibernateFlushMode not valid on jakarta.persistence.StoredProcedureQuery");
    }

    @Override
    public ProcedureCallImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(String name, P value, AllowableParameterType<P> type) {
        super.setParameter(name, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(int position, P value, AllowableParameterType<P> type) {
        super.setParameter(position, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(String name, P value, BasicTypeReference<P> type) {
        super.setParameter(name, (Object)value, (BasicTypeReference)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(int position, P value, BasicTypeReference<P> type) {
        super.setParameter(position, (Object)value, (BasicTypeReference)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P val, BasicTypeReference<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)val, (BasicTypeReference)type);
        return this;
    }

    @Override
    public <P> ProcedureCallImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalPrecision) {
        super.setParameter((QueryParameter)parameter, (Object)value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Object value, TemporalType temporalPrecision) {
        super.setParameter(name, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Object value, TemporalType temporalPrecision) {
        super.setParameter(position, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<Calendar> parameter, Calendar value, TemporalType temporalPrecision) {
        super.setParameter((Parameter)parameter, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(Parameter<Date> parameter, Date value, TemporalType temporalPrecision) {
        super.setParameter((Parameter)parameter, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Calendar value, TemporalType temporalPrecision) {
        super.setParameter(name, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(String name, Date value, TemporalType temporalPrecision) {
        super.setParameter(name, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Calendar value, TemporalType temporalPrecision) {
        super.setParameter(position, value, temporalPrecision);
        return this;
    }

    @Override
    public ProcedureCallImplementor<R> setParameter(int position, Date value, TemporalType temporalPrecision) {
        super.setParameter(position, value, temporalPrecision);
        return this;
    }

    @Override
    public Stream getResultStream() {
        return this.getResultList().stream();
    }

    public ResultSetMapping getResultSetMapping() {
        return this.resultSetMapping;
    }
}

