/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.AbstractQueryParameter;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.type.BasicType;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class ProcedureParameterImpl<T>
extends AbstractQueryParameter<T>
implements ProcedureParameterImplementor<T> {
    private static final Logger log = Logger.getLogger(ProcedureParameterImpl.class);
    private final String name;
    private Integer position;
    private final ParameterMode mode;
    private final Class<T> javaType;

    public ProcedureParameterImpl(String name, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType) {
        super(false, hibernateType);
        this.name = name;
        this.position = null;
        this.mode = mode;
        this.javaType = javaType;
    }

    public ProcedureParameterImpl(Integer position, ParameterMode mode, Class<T> javaType, AllowableParameterType<T> hibernateType) {
        super(false, hibernateType);
        this.name = null;
        this.position = position;
        this.mode = mode;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public ParameterMode getMode() {
        return this.mode;
    }

    @Override
    public Class<T> getParameterType() {
        return this.javaType;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.getName() != null) {
                return new ProcedureParameterImpl<T>(this.getName(), this.getMode(), this.javaType, this.getHibernateType());
            }
            return new ProcedureParameterImpl<T>(this.getPosition(), this.getMode(), this.javaType, this.getHibernateType());
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureParameterImpl that = (ProcedureParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.position, that.position) && this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.position, this.mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare(CallableStatement statement, int startIndex, ProcedureCallImplementor<?> procedureCall) throws SQLException {
        QueryParameterBinding binding = procedureCall.getParameterBindings().getBinding(this);
        TypeConfiguration typeConfiguration = procedureCall.getSession().getFactory().getTypeConfiguration();
        AllowableParameterType typeToUse = BindingTypeHelper.INSTANCE.resolveTemporalPrecision(binding == null || binding.getExplicitTemporalPrecision() == null ? null : binding.getExplicitTemporalPrecision(), this.getHibernateType(), typeConfiguration);
        if (this.mode == ParameterMode.INOUT || this.mode == ParameterMode.OUT) {
            JdbcType recommendedJdbcType = typeToUse.getExpressableJavaTypeDescriptor().getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
            if (procedureCall.getParameterStrategy() == ParameterStrategy.NAMED && this.canDoNameParameterBinding(typeToUse, procedureCall)) {
                statement.registerOutParameter(this.getName(), recommendedJdbcType.getJdbcTypeCode());
            } else {
                if (this.position == null) {
                    this.position = startIndex;
                }
                statement.registerOutParameter(startIndex, recommendedJdbcType.getJdbcTypeCode());
            }
        }
        if (this.mode != ParameterMode.INOUT && this.mode != ParameterMode.IN) return;
        if (!(typeToUse instanceof BasicType)) {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
        BasicType basicType = (BasicType)typeToUse;
        ValueBinder binder = basicType.getJdbcValueBinder();
        if (binding == null || binding.getBindValue() == null) {
            if ((binding == null || !binding.isBound()) && !this.isPassNullsEnabled()) throw new IllegalArgumentException("The parameter " + (this.name != null ? "named [" + this.name + "]" : "at position [" + this.position + "]") + " was not set! You need to call the setParameter method.");
            log.debugf("Stored procedure [%s] IN/INOUT parameter [%s] not bound and `passNulls` was set to true; binding NULL", (Object)procedureCall.getProcedureName(), (Object)this);
            if (procedureCall.getParameterStrategy() == ParameterStrategy.NAMED && this.canDoNameParameterBinding(typeToUse, procedureCall)) {
                ((ProcedureParameterNamedBinder)((Object)typeToUse)).nullSafeSet(statement, null, this.getName(), procedureCall.getSession());
                return;
            } else {
                if (this.position == null) {
                    this.position = startIndex;
                }
                binder.bind((PreparedStatement)statement, null, this.position, (WrapperOptions)procedureCall.getSession());
            }
            return;
        } else if (procedureCall.getParameterStrategy() == ParameterStrategy.NAMED && this.canDoNameParameterBinding(typeToUse, procedureCall)) {
            ((ProcedureParameterNamedBinder)((Object)typeToUse)).nullSafeSet(statement, binding.getBindValue(), this.getName(), procedureCall.getSession());
            return;
        } else {
            if (this.position == null) {
                this.position = startIndex;
            }
            binder.bind((PreparedStatement)statement, binding.getBindValue(), this.position, (WrapperOptions)procedureCall.getSession());
        }
    }

    private boolean canDoNameParameterBinding(AllowableParameterType<?> hibernateType, ProcedureCallImplementor<?> procedureCall) {
        ExtractedDatabaseMetaData databaseMetaData = procedureCall.getSession().getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext().getServiceRegistry().getService(JdbcEnvironment.class).getExtractedDatabaseMetaData();
        return databaseMetaData.supportsNamedParameters() && hibernateType instanceof ProcedureParameterNamedBinder && ((ProcedureParameterNamedBinder)((Object)hibernateType)).canDoSetting();
    }
}

