/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Locale;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaQueryStructure;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class QualifiedJoinPredicatePathConsumer
extends BasicDotIdentifierConsumer {
    private final SqmQualifiedJoin<?, ?> sqmJoin;

    public QualifiedJoinPredicatePathConsumer(SqmQualifiedJoin<?, ?> sqmJoin, SqmCreationState creationState) {
        super(creationState);
        this.sqmJoin = sqmJoin;
    }

    @Override
    protected SemanticPathPart createBasePart() {
        return new BasicDotIdentifierConsumer.BaseLocalSequencePart(){

            @Override
            protected void validateAsRoot(SqmFrom<?, ?> pathRoot) {
                SqmRoot<?> root = pathRoot.findRoot();
                if (root != QualifiedJoinPredicatePathConsumer.this.sqmJoin.findRoot()) {
                    JpaQueryStructure querySpec;
                    SqmQuery<?> processingQuery = QualifiedJoinPredicatePathConsumer.this.getCreationState().getCurrentProcessingState().getProcessingQuery();
                    if (processingQuery instanceof SqmSubQuery && (((SqmQuerySpec)(querySpec = ((SqmSubQuery)processingQuery).getQuerySpec())).getFromClause() == null || !((SqmQuerySpec)querySpec).getFromClause().getRoots().contains(root))) {
                        super.validateAsRoot(pathRoot);
                        return;
                    }
                    throw new SemanticException(String.format(Locale.ROOT, "SqmQualifiedJoin predicate referred to SqmRoot [`%s`] other than the join's root [`%s`]", pathRoot.getNavigablePath().getFullPath(), QualifiedJoinPredicatePathConsumer.this.sqmJoin.getNavigablePath().getFullPath()));
                }
                super.validateAsRoot(pathRoot);
            }
        };
    }
}

