/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteFetchBuilder;
import org.hibernate.query.results.complete.ModelPartReferenceEntity;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderEntityValuedModelPart
implements CompleteFetchBuilder,
ModelPartReferenceEntity {
    private final NavigablePath navigablePath;
    private final EntityValuedFetchable modelPart;
    private final List<String> columnAliases;

    public CompleteFetchBuilderEntityValuedModelPart(NavigablePath navigablePath, EntityValuedFetchable modelPart, List<String> columnAliases) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.columnAliases = columnAliases;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedFetchable getReferencedPart() {
        return this.modelPart;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        assert (fetchPath.equals(this.navigablePath));
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
        this.modelPart.forEachSelectable((selectionIndex, selectableMapping) -> {
            TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, selectableMapping.getContainingTableExpression());
            String mappedColumn = selectableMapping.getSelectionExpression();
            String columnAlias = this.columnAliases.get(selectionIndex);
            creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mappedColumn), processingState -> {
                int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(columnAlias);
                int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
                return new SqlSelectionImpl(valuesArrayPosition, selectableMapping.getJdbcMapping());
            }), this.modelPart.getJavaTypeDescriptor(), creationStateImpl.getSessionFactory().getTypeConfiguration());
        });
        return parent.generateFetchableFetch(this.modelPart, fetchPath, FetchTiming.DELAYED, true, null, domainResultCreationState);
    }
}

