/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class CompleteResultBuilderBasicValuedStandard
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final BasicValuedMapping explicitType;
    private final JavaType<?> explicitJavaTypeDescriptor;

    public CompleteResultBuilderBasicValuedStandard(String explicitColumnName, BasicValuedMapping explicitType, JavaType<?> explicitJavaTypeDescriptor) {
        assert (explicitType == null || explicitType.getJdbcMapping().getJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(explicitJavaTypeDescriptor.getJavaTypeClass()));
        this.explicitColumnName = explicitColumnName;
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = explicitJavaTypeDescriptor;
    }

    @Override
    public Class<?> getJavaType() {
        return this.explicitJavaTypeDescriptor.getJavaTypeClass();
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        String columnName = this.explicitColumnName != null ? this.explicitColumnName : jdbcResultsMetadata.resolveColumnName(resultPosition + 1);
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(columnName, processingState -> {
            int jdbcPosition = this.explicitColumnName != null ? jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName) : resultPosition + 1;
            BasicType<?> basicType = this.explicitType != null ? this.explicitType : jdbcResultsMetadata.resolveType(jdbcPosition, this.explicitJavaTypeDescriptor, sessionFactory);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new SqlSelectionImpl(valuesArrayPosition, basicType);
        }), this.explicitJavaTypeDescriptor, sessionFactory.getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), columnName, sqlSelection.getExpressionType().getJdbcMappings().get(0).getMappedJavaTypeDescriptor());
    }
}

