/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.List;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;

public class EntityResultImpl
implements EntityResult {
    private final NavigablePath navigablePath;
    private final EntityValuedModelPart entityValuedModelPart;
    private final Fetch identifierFetch;
    private final BasicFetch<?> discriminatorFetch;
    private final List<Fetch> fetches;
    private final String resultAlias;
    private final LockMode lockMode;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultAlias, LockMode lockMode, Function<EntityResultImpl, BasicFetch<?>> discriminatorFetchBuilder, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.entityValuedModelPart = entityValuedModelPart;
        this.resultAlias = resultAlias;
        this.lockMode = lockMode;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        sqlAstCreationState.getFromClauseAccess().resolveTableGroup(navigablePath, np -> entityValuedModelPart.getEntityMappingType().getEntityPersister().createRootTableGroup(true, navigablePath, null, () -> p -> {}, sqlAstCreationState, sqlAstCreationState.getCreationContext().getSessionFactory()));
        this.discriminatorFetch = discriminatorFetchBuilder.apply(this);
        this.fetches = creationState.visitFetches(this);
        EntityIdentifierMapping identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
        String idAttributeName = identifierMapping instanceof SingleAttributeIdentifierMapping ? ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName() : null;
        MutableObject<Fetch> idFetchRef = new MutableObject<Fetch>();
        for (int i = 0; i < this.fetches.size(); ++i) {
            Fetch fetch = this.fetches.get(i);
            String fetchLocalName = fetch.getNavigablePath().getLocalName();
            if (!fetchLocalName.equals("{id}") && (idAttributeName == null || !fetchLocalName.equals(idAttributeName))) continue;
            idFetchRef.set(fetch);
            this.fetches.remove(i);
            break;
        }
        this.identifierFetch = idFetchRef.isNotSet() ? ((Fetchable)((Object)identifierMapping)).generateFetch(this, new EntityIdentifierNavigablePath(navigablePath, ResultsHelper.attributeName(identifierMapping)), FetchTiming.IMMEDIATE, true, null, creationState) : (Fetch)idFetchRef.get();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedModelPart getReferencedMappingType() {
        return this.entityValuedModelPart;
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.entityValuedModelPart;
    }

    @Override
    public String getResultVariable() {
        return this.resultAlias;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        for (int i = 0; i < this.fetches.size(); ++i) {
            if (!this.fetches.get(i).getFetchedMapping().getFetchableName().equals(fetchable.getFetchableName())) continue;
            return this.fetches.get(i);
        }
        return null;
    }

    public DomainResultAssembler<?> createResultAssembler(AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.lockMode, this.identifierFetch, this.discriminatorFetch, null, creationState));
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }
}

