/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderBasic;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class DynamicResultBuilderBasicStandard
implements DynamicResultBuilderBasic {
    private final String columnName;
    private final int columnPosition;
    private final String resultAlias;
    private final BasicType<?> explicitType;
    private final JavaType<?> explicitJavaTypeDescriptor;

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        this.resultAlias = resultAlias != null ? resultAlias : columnName;
        this.explicitType = null;
        this.explicitJavaTypeDescriptor = null;
    }

    public DynamicResultBuilderBasicStandard(int columnPosition) {
        assert (columnPosition > 0);
        this.columnName = "c" + columnPosition;
        this.columnPosition = columnPosition;
        this.resultAlias = this.columnName;
        this.explicitType = null;
        this.explicitJavaTypeDescriptor = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, JavaType<?> explicitJavaTypeDescriptor) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitJavaTypeDescriptor != null);
        this.explicitJavaTypeDescriptor = explicitJavaTypeDescriptor;
        this.explicitType = null;
    }

    public DynamicResultBuilderBasicStandard(String columnName, String resultAlias, BasicType<?> explicitType) {
        assert (columnName != null);
        this.columnName = columnName;
        this.columnPosition = 0;
        String string = this.resultAlias = resultAlias != null ? resultAlias : columnName;
        assert (explicitType != null);
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = null;
    }

    public DynamicResultBuilderBasicStandard(int columnPosition, BasicType<?> explicitType) {
        assert (columnPosition > 0);
        this.columnName = "c" + columnPosition;
        this.columnPosition = columnPosition;
        this.resultAlias = this.columnName;
        assert (explicitType != null);
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = null;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.explicitJavaTypeDescriptor != null) {
            return this.explicitJavaTypeDescriptor.getJavaTypeClass();
        }
        if (this.explicitType != null) {
            return this.explicitType.getJavaType();
        }
        return null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        SessionFactoryImplementor sessionFactory = domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        Expression expression = sqlExpressionResolver.resolveSqlExpression(this.columnName, state -> {
            int jdbcPosition = this.columnPosition > 0 ? this.columnPosition : jdbcResultsMetadata.resolveColumnPosition(this.columnName);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            BasicType<?> basicType = this.explicitType != null ? this.explicitType : jdbcResultsMetadata.resolveType(jdbcPosition, this.explicitJavaTypeDescriptor, sessionFactory);
            return new SqlSelectionImpl(valuesArrayPosition, basicType);
        });
        JavaType javaTypeDescriptor = this.explicitJavaTypeDescriptor != null ? this.explicitJavaTypeDescriptor : expression.getExpressionType().getJdbcMappings().get(0).getMappedJavaTypeDescriptor();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(expression, javaTypeDescriptor, sessionFactory.getTypeConfiguration());
        assert (javaTypeDescriptor != null);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.resultAlias, javaTypeDescriptor);
    }
}

