/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.ManagedType;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.QueryHints;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractQuery<R>
implements QueryImplementor<R> {
    protected static final EntityManagerMessageLogger log = HEMLogging.messageLogger(AbstractQuery.class);
    private final SharedSessionContractImplementor session;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;

    public AbstractQuery(SharedSessionContractImplementor session) {
        this.session = session;
    }

    protected void applyOptions(NamedQueryMemento memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach((string, object) -> this.setHint((String)string, object));
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected abstract QueryParameterBindings getQueryParameterBindings();

    @Override
    public abstract ParameterMetadataImplementor getParameterMetadata();

    @Override
    public abstract MutableQueryOptions getQueryOptions();

    public int getMaxResults() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getMaxRowsJpa();
    }

    @Override
    public QueryImplementor<R> setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("max-results cannot be negative");
        }
        this.getSession().checkOpen();
        this.getQueryOptions().getLimit().setMaxRows(maxResult);
        return this;
    }

    public int getFirstResult() {
        this.getSession().checkOpen();
        return this.getQueryOptions().getLimit().getFirstRowJpa();
    }

    @Override
    public QueryImplementor<R> setFirstResult(int startPosition) {
        this.getSession().checkOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
        return this;
    }

    @Override
    public QueryImplementor<R> setTupleTransformer(TupleTransformer transformer) {
        this.getQueryOptions().setTupleTransformer(transformer);
        return this;
    }

    @Override
    public QueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        this.getQueryOptions().setResultListTransformer(transformer);
        return this;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.getQueryOptions().getFlushMode();
    }

    @Override
    public QueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        this.getQueryOptions().setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        this.getSession().checkOpen();
        FlushMode flushMode = this.getQueryOptions().getFlushMode() == null ? this.getSession().getHibernateFlushMode() : this.getQueryOptions().getFlushMode();
        return FlushModeTypeHelper.getFlushModeType(flushMode);
    }

    @Override
    public QueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        this.getSession().checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public QueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
    }

    @Override
    public QueryImplementor<R> setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public QueryImplementor<R> setCacheRegion(String cacheRegion) {
        this.getQueryOptions().setResultCacheRegionName(cacheRegion);
        return this;
    }

    @Override
    public Integer getTimeout() {
        return this.getQueryOptions().getTimeout();
    }

    @Override
    public QueryImplementor<R> setTimeout(int timeout) {
        this.getQueryOptions().setTimeout(timeout);
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.getQueryOptions().getFetchSize();
    }

    @Override
    public QueryImplementor<R> setFetchSize(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public QueryImplementor<R> setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    public LockModeType getLockMode() {
        this.getSession().checkOpen(false);
        return LockModeTypeHelper.getLockModeType(this.getQueryOptions().getLockOptions().getLockMode());
    }

    @Override
    public QueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().setLockMode(lockOptions.getLockMode());
        this.getQueryOptions().getLockOptions().setScope(lockOptions.getScope());
        this.getQueryOptions().getLockOptions().setTimeOut(lockOptions.getTimeOut());
        this.getQueryOptions().getLockOptions().setFollowOnLocking(lockOptions.getFollowOnLocking());
        return this;
    }

    @Override
    public QueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public QueryImplementor<R> setLockMode(LockModeType lockModeType) {
        this.getSession().checkOpen();
        this.getQueryOptions().getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    @Override
    public QueryImplementor<R> setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    @Override
    public QueryImplementor<R> addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public Map<String, Object> getHints() {
        this.getSession().checkOpen(false);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.collectHints(hints);
        return hints;
    }

    protected void collectHints(Map<String, Object> hints) {
        if (this.getQueryOptions().getTimeout() != null) {
            hints.put("org.hibernate.timeout", this.getQueryOptions().getTimeout());
            hints.put("javax.persistence.query.timeout", this.getQueryOptions().getTimeout() * 1000);
        }
        if (this.getLockOptions().getTimeOut() != -1) {
            hints.put("javax.persistence.lock.timeout", this.getLockOptions().getTimeOut());
            hints.put("jakarta.persistence.lock.timeout", this.getLockOptions().getTimeOut());
        }
        if (this.getLockOptions().getScope()) {
            hints.put("javax.persistence.lock.scope", this.getLockOptions().getScope());
            hints.put("jakarta.persistence.lock.scope", this.getLockOptions().getScope());
        }
        if (this.getLockOptions().hasAliasSpecificLockModes()) {
            for (Map.Entry<String, LockMode> entry : this.getLockOptions().getAliasSpecificLocks()) {
                hints.put("org.hibernate.lockMode." + entry.getKey(), entry.getValue().name());
            }
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getQueryOptions().getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getHibernateFlushMode());
        if (this.getCacheMode() != null) {
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
        }
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Enum<?> hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Object hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    @Override
    public QueryImplementor<R> setHint(String hintName, Object value) {
        this.getSession().checkOpen(true);
        boolean applied = false;
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                applied = this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("javax.persistence.query.timeout".equals(hintName)) {
                int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                applied = this.applyTimeoutHint(timeout);
            } else if ("javax.persistence.lock.timeout".equals(hintName)) {
                applied = this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.comment".equals(hintName)) {
                applied = this.applyCommentHint((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                applied = this.applyFetchSizeHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                applied = this.applyCacheableHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                applied = this.applyCacheRegionHint((String)value);
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                applied = this.applyReadOnlyHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                applied = this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                applied = this.applyCacheModeHint(ConfigurationHelper.getCacheMode(value));
            } else if ("jakarta.persistence.cache.retrieveMode".equals(hintName)) {
                CacheRetrieveMode retrieveMode = value != null ? CacheRetrieveMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheRetrieveMode(retrieveMode);
            } else if ("jakarta.persistence.cache.storeMode".equals(hintName)) {
                CacheStoreMode storeMode = value != null ? CacheStoreMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheStoreMode(storeMode);
            } else if ("javax.persistence.cache.retrieveMode".equals(hintName)) {
                CacheRetrieveMode retrieveMode = value != null ? CacheRetrieveMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheRetrieveMode(retrieveMode);
            } else if ("javax.persistence.cache.storeMode".equals(hintName)) {
                CacheStoreMode storeMode = value != null ? CacheStoreMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheStoreMode(storeMode);
            } else if ("org.hibernate.lockMode".equals(hintName)) {
                applied = this.applyNativeQueryLockMode(value);
            } else if (hintName.startsWith("org.hibernate.lockMode")) {
                String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
                try {
                    LockMode lockMode = LockModeTypeHelper.interpretLockMode(value);
                    this.applyAliasSpecificLockModeHint(alias, lockMode);
                    applied = true;
                }
                catch (Exception e) {
                    log.unableToDetermineLockModeValue(hintName, value);
                    applied = false;
                }
            } else if (QueryHints.JAKARTA_HINT_FETCH_GRAPH.equals(hintName) || QueryHints.JAKARTA_HINT_LOAD_GRAPH.equals(hintName)) {
                if (value instanceof RootGraphImplementor) {
                    this.applyEntityGraphQueryHint(hintName, (RootGraphImplementor)value);
                } else {
                    log.warnf("The %s hint was set, but the value was not an EntityGraph!", hintName);
                }
                applied = true;
            } else if (QueryHints.HINT_FETCHGRAPH.equals(hintName) || QueryHints.HINT_LOADGRAPH.equals(hintName)) {
                if (QueryHints.HINT_FETCHGRAPH.equals(hintName)) {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting(QueryHints.HINT_FETCHGRAPH, QueryHints.JAKARTA_HINT_FETCH_GRAPH);
                } else {
                    assert (QueryHints.HINT_LOADGRAPH.equals(hintName));
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting(QueryHints.HINT_FETCHGRAPH, QueryHints.JAKARTA_HINT_FETCH_GRAPH);
                }
                if (value instanceof RootGraphImplementor) {
                    this.applyEntityGraphQueryHint(hintName, (RootGraphImplementor)value);
                } else {
                    log.warnf("The %s hint was set, but the value was not an EntityGraph!", hintName);
                }
                applied = true;
            } else if ("hibernate.query.followOnLocking".equals(hintName)) {
                applied = this.applyFollowOnLockingHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.query.native.spaces".equals(hintName)) {
                applied = this.applySynchronizeSpacesHint(value);
            } else {
                log.ignoringUnrecognizedQueryHint(hintName);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        if (!applied) {
            log.debugf("Skipping unsupported query hint [%s]", hintName);
        }
        return this;
    }

    protected boolean applyJpaCacheRetrieveMode(CacheRetrieveMode retrieveMode) {
        this.getQueryOptions().setCacheRetrieveMode(retrieveMode);
        return true;
    }

    protected boolean applyJpaCacheStoreMode(CacheStoreMode storeMode) {
        this.getQueryOptions().setCacheStoreMode(storeMode);
        return true;
    }

    protected boolean applyNativeQueryLockMode(Object value) {
        return false;
    }

    protected boolean applySynchronizeSpacesHint(Object value) {
        return false;
    }

    protected boolean applyTimeoutHint(int timeout) {
        this.setTimeout(timeout);
        return true;
    }

    protected boolean applyLockTimeoutHint(int timeout) {
        this.getLockOptions().setTimeOut(timeout);
        return true;
    }

    protected boolean applyCommentHint(String comment) {
        this.setComment(comment);
        return true;
    }

    protected boolean applyFetchSizeHint(int fetchSize) {
        this.setFetchSize(fetchSize);
        return true;
    }

    protected boolean applyCacheableHint(boolean isCacheable) {
        this.setCacheable(isCacheable);
        return true;
    }

    protected boolean applyCacheRegionHint(String regionName) {
        this.setCacheRegion(regionName);
        return true;
    }

    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.setReadOnly(isReadOnly);
        return true;
    }

    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.setCacheMode(cacheMode);
        return true;
    }

    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
        return true;
    }

    protected boolean applyLockModeTypeHint(LockModeType lockModeType) {
        this.getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return true;
    }

    protected boolean applyHibernateLockModeHint(LockMode lockMode) {
        if (lockMode == LockMode.NONE) {
            LockOptions lockOptions = LockOptions.NONE;
        } else if (lockMode == LockMode.READ) {
            LockOptions lockOptions = LockOptions.READ;
        } else if (lockMode == LockMode.UPGRADE || lockMode == LockMode.PESSIMISTIC_WRITE) {
            LockOptions lockOptions = LockOptions.UPGRADE;
        }
        return true;
    }

    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
        this.setLockMode(alias, lockMode);
    }

    protected abstract void applyEntityGraphQueryHint(String var1, RootGraphImplementor<?> var2);

    protected boolean applyFollowOnLockingHint(Boolean followOnLocking) {
        this.getLockOptions().setFollowOnLocking(followOnLocking);
        return true;
    }

    protected boolean resolveJdbcParameterTypeIfNecessary() {
        return true;
    }

    public Set<Parameter<?>> getParameters() {
        this.getSession().checkOpen(false);
        return this.getParameterMetadata().getRegistrations();
    }

    public Parameter<?> getParameter(String name) {
        this.getSession().checkOpen(false);
        try {
            return this.getParameterMetadata().getQueryParameter(name);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(name);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to name [" + name + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public Parameter<?> getParameter(int position) {
        this.getSession().checkOpen(false);
        try {
            return this.getParameterMetadata().getQueryParameter(position);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter parameter = this.getParameterMetadata().getQueryParameter(position);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to position [" + position + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
    }

    public boolean isBound(Parameter<?> param) {
        this.getSession().checkOpen();
        QueryParameter qp = this.getParameterMetadata().resolve((Parameter)param);
        return qp != null && this.getQueryParameterBindings().isBound((QueryParameterImplementor<?>)qp);
    }

    protected <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        if (parameter instanceof QueryParameterImplementor) {
            return this.locateBinding((QueryParameterImplementor)parameter);
        }
        if (parameter.getName() != null) {
            return this.locateBinding(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.locateBinding(parameter.getPosition());
        }
        throw this.getSession().getExceptionConverter().convert(new IllegalArgumentException("Could not resolve binding for given parameter reference [" + parameter + "]"));
    }

    protected <P> QueryParameterBinding<P> locateBinding(QueryParameterImplementor<P> parameter) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(parameter);
    }

    protected <P> QueryParameterBinding<P> locateBinding(String name) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(name);
    }

    protected <P> QueryParameterBinding<P> locateBinding(int position) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding(position);
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            AllowableParameterType type = typedValue.getType();
            if (type != null) {
                this.setParameter(parameter, typedValue.getValue(), type);
            } else {
                this.setParameter(parameter, typedValue.getValue(), typedValue.getTypeReference());
            }
        } else {
            this.locateBinding(parameter).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        }
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, P value, BasicTypeReference<P> type) {
        this.setParameter(parameter, value, this.session.getTypeConfiguration().getBasicTypeRegistry().resolve(type));
    }

    private <P> void setParameter(Parameter<P> parameter, P value, AllowableParameterType<P> type) {
        if (parameter instanceof QueryParameter) {
            this.setParameter((QueryParameter)parameter, (Object)value, (AllowableParameterType)type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, type);
        } else if (value instanceof Collection) {
            this.locateBinding(parameter).setBindValues((Collection)value);
        } else {
            this.locateBinding(parameter).setBindValue(value, type);
        }
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value) {
        AllowableParameterType hibernateType;
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            AllowableParameterType type = typedValue.getType();
            if (type != null) {
                return this.setParameter(name, typedValue.getValue(), type);
            }
            return this.setParameter(name, typedValue.getValue(), typedValue.getTypeReference());
        }
        QueryParameter param = this.getParameterMetadata().getQueryParameter(name);
        if (param.allowsMultiValuedBinding() && ((hibernateType = param.getHibernateType()) == null || !hibernateType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isInstance(value)) && value instanceof Collection) {
            this.setParameterList(name, (Collection)value);
        }
        this.locateBinding(name).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value) {
        AllowableParameterType hibernateType;
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValue = (TypedParameterValue)value;
            AllowableParameterType type = typedValue.getType();
            if (type != null) {
                return this.setParameter(position, typedValue.getValue(), type);
            }
            return this.setParameter(position, typedValue.getValue(), typedValue.getTypeReference());
        }
        QueryParameter param = this.getParameterMetadata().getQueryParameter(position);
        if (param.allowsMultiValuedBinding() && ((hibernateType = param.getHibernateType()) == null || !hibernateType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isInstance(value)) && value instanceof Collection) {
            this.setParameterList(param, (Collection)value);
        }
        this.locateBinding(position).setBindValue(value, this.resolveJdbcParameterTypeIfNecessary());
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType<P> type) {
        this.locateBinding(parameter).setBindValue(value, type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, AllowableParameterType<P> type) {
        this.locateBinding(name).setBindValue(value, type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, AllowableParameterType<P> type) {
        this.locateBinding(position).setBindValue(value, type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameter(String name, P value, BasicTypeReference<P> type) {
        return this.setParameter(name, (Object)value, (AllowableParameterType)this.session.getTypeConfiguration().getBasicTypeRegistry().resolve(type));
    }

    @Override
    public <P> QueryImplementor<R> setParameter(int position, P value, BasicTypeReference<P> type) {
        return this.setParameter(position, (Object)value, (AllowableParameterType)this.session.getTypeConfiguration().getBasicTypeRegistry().resolve(type));
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P val, BasicTypeReference<P> type) {
        return this.setParameter((QueryParameter)parameter, (Object)val, (AllowableParameterType)this.session.getTypeConfiguration().getBasicTypeRegistry().resolve(type));
    }

    @Override
    public <P> QueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        this.locateBinding(parameter).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<P> values) {
        this.locateBinding(parameter).setBindValues(values);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Collection<?> values) {
        this.locateBinding(name).setBindValues(values);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Collection<?> values) {
        this.locateBinding(position).setBindValues(values);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, AllowableParameterType<P> type) {
        this.locateBinding(name).setBindValues(values, type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, AllowableParameterType<P> type) {
        this.locateBinding(position).setBindValues(values, type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values) {
        this.locateBinding(name).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values) {
        this.locateBinding(position).setBindValues(Arrays.asList(values));
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType<?> type) {
        this.locateBinding(name).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType<?> type) {
        this.locateBinding(position).setBindValues(Arrays.asList(values), type);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(name, (Collection)values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine AllowableParameterType : " + javaType.getName());
                }
            }
            this.setParameterList(name, (Collection)values, (AllowableParameterType)paramType);
        }
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        JavaType javaDescriptor = this.getSession().getFactory().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(javaType);
        if (javaDescriptor == null) {
            this.setParameterList(position, (Collection)values);
        } else {
            ManagedType paramType;
            ManagedType basicType = this.getSession().getFactory().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
            if (basicType != null) {
                paramType = basicType;
            } else {
                ManagedType managedDomainType = this.getSession().getFactory().getRuntimeMetamodels().getJpaMetamodel().managedType(javaType);
                if (managedDomainType != null) {
                    paramType = managedDomainType;
                } else {
                    throw new HibernateException("Unable to determine AllowableParameterType : " + javaType.getName());
                }
            }
            this.setParameterList(position, (Collection)values, (AllowableParameterType)paramType);
        }
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        QueryLogging.QUERY_LOGGER.tracef("#getParameterValue(%s)", param);
        this.getSession().checkOpen(false);
        QueryParameter qp = this.getParameterMetadata().resolve((Parameter)param);
        if (qp == null) {
            throw new IllegalArgumentException("The parameter [" + param + "] is not part of this Query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(qp);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + param.toString());
        }
        if (binding.isMultiValued()) {
            return (T)binding.getBindValues();
        }
        return (T)binding.getBindValue();
    }

    public Object getParameterValue(String name) {
        this.getSession().checkOpen(false);
        QueryParameter parameter = this.getParameterMetadata().getQueryParameter(name);
        if (parameter == null) {
            throw new IllegalArgumentException("Could not resolve parameter by name - " + name);
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(parameter);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + parameter.toString());
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    public Object getParameterValue(int position) {
        QueryParameter parameter = this.getParameterMetadata().getQueryParameter(position);
        if (parameter == null) {
            throw new IllegalArgumentException("Could not resolve parameter by position - " + position);
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding(parameter);
        if (binding == null || !binding.isBound()) {
            throw new IllegalStateException("The parameter [" + position + "] has not yet been bound");
        }
        if (binding.isMultiValued()) {
            return binding.getBindValues();
        }
        return binding.getBindValue();
    }

    protected void beforeQuery(boolean requiresTxn) {
        CacheMode effectiveCacheMode;
        this.getQueryParameterBindings().validate();
        this.getSession().prepareForQueryExecution(requiresTxn);
        this.prepareForExecution();
        assert (this.sessionFlushMode == null);
        assert (this.sessionCacheMode == null);
        FlushMode effectiveFlushMode = this.getHibernateFlushMode();
        if (effectiveFlushMode != null) {
            this.sessionFlushMode = this.getSession().getHibernateFlushMode();
            this.getSession().setHibernateFlushMode(effectiveFlushMode);
        }
        if ((effectiveCacheMode = this.getCacheMode()) != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(effectiveCacheMode);
        }
    }

    protected void prepareForExecution() {
    }

    @Override
    public QueryImplementor<R> setProperties(Object bean) {
        Class<?> clazz = bean.getClass();
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            try {
                PropertyAccess propertyAccess = BuiltInPropertyAccessStrategies.BASIC.getStrategy().buildPropertyAccess(clazz, paramName);
                Getter getter = propertyAccess.getGetter();
                Class<?> retType = getter.getReturnTypeClass();
                Object object = getter.get(bean);
                if (Collection.class.isAssignableFrom(retType)) {
                    this.setParameterList(paramName, (Collection)object);
                    continue;
                }
                if (retType.isArray()) {
                    this.setParameterList(paramName, (Object[])object);
                    continue;
                }
                AllowableParameterType<Object> type = this.determineType(paramName, retType);
                this.setParameter(paramName, object, (AllowableParameterType)type);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        }
        return this;
    }

    protected AllowableParameterType<Object> determineType(String namedParam, Class<?> retType) {
        AllowableParameterType<Object> type = this.locateBinding(namedParam).getBindType();
        if (type == null) {
            type = this.getParameterMetadata().getQueryParameter(namedParam).getHibernateType();
        }
        if (type == null && retType != null) {
            type = this.getSession().getFactory().resolveParameterBindType(retType);
        }
        return type;
    }

    @Override
    public QueryImplementor<R> setProperties(Map map) {
        for (String paramName : this.getParameterMetadata().getNamedParameterNames()) {
            Object object = map.get(paramName);
            if (object == null) {
                if (!map.containsKey(paramName)) continue;
                this.setParameter(paramName, (Object)null, (AllowableParameterType)this.determineType(paramName, null));
                continue;
            }
            Class<?> retType = object.getClass();
            if (Collection.class.isAssignableFrom(retType)) {
                this.setParameterList(paramName, (Collection)object);
                continue;
            }
            if (retType.isArray()) {
                this.setParameterList(paramName, (Object[])object);
                continue;
            }
            this.setParameter(paramName, object, (AllowableParameterType)this.determineType(paramName, retType));
        }
        return this;
    }

    protected void afterQuery(boolean success) {
        if (this.sessionFlushMode != null) {
            this.getSession().setHibernateFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
        if (!this.session.isTransactionInProgress()) {
            this.session.getJdbcCoordinator().getLogicalConnection().afterTransaction();
        }
        this.session.afterOperation(success);
    }

    @Override
    public List<R> list() {
        this.beforeQuery(false);
        boolean success = false;
        try {
            List<R> result = this.doList();
            success = true;
            List<R> list = result;
            return list;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he, this.getLockOptions());
        }
        finally {
            this.afterQuery(success);
        }
    }

    protected abstract List<R> doList();

    @Override
    public R uniqueResult() {
        return AbstractQuery.uniqueElement(this.list());
    }

    @Override
    public R getSingleResult() {
        try {
            List<R> list = this.list();
            if (list.size() == 0) {
                throw new NoResultException("No entity found for query");
            }
            return AbstractQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e, this.getLockOptions());
        }
    }

    public static <R> R uniqueElement(List<R> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        R first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return Optional.ofNullable(this.uniqueResult());
    }

    @Override
    public ScrollableResultsImplementor<R> scroll() {
        return this.scroll(this.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getDialect().defaultScrollMode());
    }

    @Override
    public Stream<R> stream() {
        ScrollableResults scrollableResults = this.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(((ScrollableResultsImplementor)scrollableResults)::close);
    }

    public int executeUpdate() throws HibernateException {
        this.getSession().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery(false);
        boolean success = false;
        try {
            int result = this.doExecuteUpdate();
            success = true;
            int n = result;
            return n;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e);
        }
        finally {
            this.afterQuery(success);
        }
    }

    protected abstract int doExecuteUpdate();

    @Override
    public void setOptionalId(Serializable id) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalEntityName(String entityName) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }

    @Override
    public void setOptionalObject(Object optionalObject) {
        throw new UnsupportedOperationException("Not sure yet how to handle this in SQM based queries, but for sure it will be different");
    }
}

