/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sql.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.NativeQueryTupleTransformer;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.Limit;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.Builders;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.ResultSetMappingImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.results.dynamic.DynamicResultBuilderInstantiation;
import org.hibernate.query.spi.AbstractQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sql.internal.NamedNativeQueryMementoImpl;
import org.hibernate.query.sql.internal.NativeNonSelectQueryPlanImpl;
import org.hibernate.query.sql.internal.ParameterRecognizerImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sql.spi.NativeSelectQueryDefinition;
import org.hibernate.query.sql.spi.NativeSelectQueryPlan;
import org.hibernate.query.sql.spi.NonSelectInterpretationsKey;
import org.hibernate.query.sql.spi.ParameterInterpretation;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sql.spi.SelectInterpretationsKey;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;

public class NativeQueryImpl<R>
extends AbstractQuery<R>
implements NativeQueryImplementor<R>,
DomainQueryExecutionContext,
ResultSetMappingResolutionContext {
    private final String sqlString;
    private final ParameterMetadataImplementor parameterMetadata;
    private final List<ParameterOccurrence> parameterOccurrences;
    private final QueryParameterBindings parameterBindings;
    private final ResultSetMappingImpl resultSetMapping;
    private final boolean resultMappingSuppliedToCtor;
    private final QueryOptionsImpl queryOptions = new QueryOptionsImpl();
    private Set<String> querySpaces;
    private Callback callback;
    private Object collectionKey;
    private NativeQueryInterpreter nativeQueryInterpreter;

    public NativeQueryImpl(NamedNativeQueryMemento memento, SharedSessionContractImplementor session) {
        this(memento, () -> {
            if (memento.getResultMappingName() != null) {
                return new ResultSetMappingImpl(memento.getResultMappingName());
            }
            if (memento.getResultMappingClass() != null) {
                return new ResultSetMappingImpl(memento.getResultMappingClass().getName());
            }
            return new ResultSetMappingImpl(memento.getSqlString());
        }, (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento resultSetMappingMemento;
            if (memento.getResultMappingName() != null && (resultSetMappingMemento = session.getFactory().getQueryEngine().getNamedObjectRepository().getResultSetMappingMemento(memento.getResultMappingName())) != null) {
                resultSetMappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
                return true;
            }
            if (memento.getResultMappingClass() != null) {
                resultSetMapping.addResultBuilder(Builders.implicitEntityResultBuilder(memento.getResultMappingClass(), context));
                return true;
            }
            return false;
        }, session);
    }

    public NativeQueryImpl(NamedNativeQueryMemento memento, Supplier<ResultSetMappingImpl> resultSetMappingCreator, ResultSetMappingHandler resultSetMappingHandler, SharedSessionContractImplementor session) {
        super(session);
        boolean appliedAnyResults;
        String mementoSqlString = memento.getSqlString();
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(mementoSqlString, session);
        this.sqlString = parameterInterpretation.getAdjustedSqlString();
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory(), session.isQueryParametersValidationEnabled());
        this.querySpaces = new HashSet<String>();
        this.resultSetMapping = resultSetMappingCreator.get();
        this.resultMappingSuppliedToCtor = appliedAnyResults = resultSetMappingHandler.resolveResultSetMapping(this.resultSetMapping, this.querySpaces::add, this);
        this.applyOptions(memento);
    }

    public NativeQueryImpl(NamedNativeQueryMemento memento, Class<R> resultJavaType, SharedSessionContractImplementor session) {
        this(memento, () -> {
            String mappingIdentifier = resultJavaType != null ? resultJavaType.getName() : null;
            return new ResultSetMappingImpl(mappingIdentifier);
        }, (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento resultSetMappingMemento;
            if (memento.getResultMappingName() != null && (resultSetMappingMemento = session.getFactory().getQueryEngine().getNamedObjectRepository().getResultSetMappingMemento(memento.getResultMappingName())) != null) {
                resultSetMappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
                return true;
            }
            if (memento.getResultMappingClass() != null) {
                resultSetMapping.addResultBuilder(Builders.implicitEntityResultBuilder(memento.getResultMappingClass(), context));
                return true;
            }
            if (resultJavaType == null || resultJavaType != Tuple.class) {
                // empty if block
            }
            return false;
        }, session);
        if (resultJavaType == Tuple.class) {
            this.setTupleTransformer((TupleTransformer)new NativeQueryTupleTransformer());
        } else if (resultJavaType != null) {
            switch (this.resultSetMapping.getNumberOfResultBuilders()) {
                case 0: {
                    throw new IllegalArgumentException("Named query exists but its result type is not compatible");
                }
                case 1: {
                    Class<?> actualResultJavaType = this.resultSetMapping.getResultBuilders().get(0).getJavaType();
                    if (resultJavaType.isAssignableFrom(actualResultJavaType)) break;
                    throw this.buildIncompatibleException(resultJavaType, actualResultJavaType);
                }
                default: {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                }
            }
        }
    }

    public NativeQueryImpl(NamedNativeQueryMemento memento, String resultSetMappingName, SharedSessionContractImplementor session) {
        this(memento, () -> new ResultSetMappingImpl(resultSetMappingName), (resultSetMapping, querySpaceConsumer, context) -> {
            NamedResultSetMappingMemento mappingMemento = session.getFactory().getQueryEngine().getNamedObjectRepository().getResultSetMappingMemento(resultSetMappingName);
            assert (mappingMemento != null);
            mappingMemento.resolve(resultSetMapping, querySpaceConsumer, context);
            return true;
        }, session);
    }

    public NativeQueryImpl(String sqlString, NamedResultSetMappingMemento resultSetMappingMemento, AbstractSharedSessionContract session) {
        super(session);
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(sqlString, session);
        this.sqlString = parameterInterpretation.getAdjustedSqlString();
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory(), session.isQueryParametersValidationEnabled());
        this.querySpaces = new HashSet<String>();
        this.resultSetMapping = new ResultSetMappingImpl(resultSetMappingMemento.getName());
        resultSetMappingMemento.resolve(this.resultSetMapping, string -> this.addSynchronizedQuerySpace((String)string), this);
        this.resultMappingSuppliedToCtor = true;
    }

    private ParameterInterpretation resolveParameterInterpretation(String sqlString, SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        QueryEngine queryEngine = sessionFactory.getQueryEngine();
        QueryInterpretationCache interpretationCache = queryEngine.getInterpretationCache();
        return interpretationCache.resolveNativeQueryParameters(sqlString, s -> {
            ParameterRecognizerImpl parameterRecognizer = new ParameterRecognizerImpl(session.getFactory());
            session.getFactory().getServiceRegistry().getService(NativeQueryInterpreter.class).recognizeParameters(sqlString, parameterRecognizer);
            return new ParameterInterpretationImpl(sqlString, parameterRecognizer);
        });
    }

    protected void applyOptions(NamedNativeQueryMemento memento) {
        super.applyOptions(memento);
        Set<String> copy = CollectionHelper.makeCopy(memento.getQuerySpaces());
        if (copy != null) {
            this.querySpaces = copy;
        }
    }

    public NativeQueryImpl(String sqlString, SharedSessionContractImplementor session) {
        super(session);
        this.querySpaces = new HashSet<String>();
        ParameterInterpretation parameterInterpretation = this.resolveParameterInterpretation(sqlString, session);
        this.sqlString = parameterInterpretation.getAdjustedSqlString();
        this.parameterMetadata = parameterInterpretation.toParameterMetadata(session);
        this.parameterOccurrences = parameterInterpretation.getOrderedParameterOccurrences();
        this.parameterBindings = QueryParameterBindingsImpl.from(this.parameterMetadata, session.getFactory(), session.isQueryParametersValidationEnabled());
        this.resultSetMapping = new ResultSetMappingImpl(sqlString);
        this.resultMappingSuppliedToCtor = false;
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        String actualResultClassName;
        String resultClassName = resultClass.getName();
        if (resultClassName.equals(actualResultClassName = actualResultClass.getName())) {
            return new IllegalArgumentException("Type specified for TypedQuery [" + resultClassName + "] is incompatible with the query return type of the same name. Both classes have the same name but are different as they have been loaded respectively by Classloaders " + resultClass.getClassLoader().toString() + ", " + actualResultClass.getClassLoader().toString() + ". This suggests a classloader bug in the Runtime executing Hibernate ORM, or in the integration code.");
        }
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClassName + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    @Override
    public String getQueryString() {
        return this.sqlString;
    }

    @Override
    public ParameterMetadataImplementor getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public Callback getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackImpl();
        }
        return this.callback;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public QueryParameterBindings getParameterBindings() {
        return this.getQueryParameterBindings();
    }

    @Override
    public NamedNativeQueryMemento toMemento(String name) {
        return new NamedNativeQueryMementoImpl(name, this.sqlString, this.resultSetMapping.getMappingIdentifier(), null, this.querySpaces, this.isCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getHibernateFlushMode(), this.isReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    @Override
    public LockModeType getLockMode() {
        throw new IllegalStateException("Illegal attempt to get lock mode on a native-query");
    }

    @Override
    public NativeQueryImplementor<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setLockMode(LockModeType lockModeType) {
        throw new IllegalStateException("Illegal attempt to set lock mode on a native-query");
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    @Override
    public NativeQueryImplementor<R> setTupleTransformer(TupleTransformer transformer) {
        return (NativeQueryImplementor)super.setTupleTransformer(transformer);
    }

    @Override
    public NativeQueryImplementor<R> setResultListTransformer(ResultListTransformer transformer) {
        return (NativeQueryImplementor)super.setResultListTransformer(transformer);
    }

    protected Boolean isSelectQuery() {
        if (this.resultMappingSuppliedToCtor || this.resultSetMapping.getNumberOfResultBuilders() > 0 || this.isReadOnly()) {
            return true;
        }
        return null;
    }

    @Override
    protected void prepareForExecution() {
        if (this.getSynchronizedQuerySpaces() != null && !this.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.shouldFlush()) {
            this.getSession().flush();
        }
        this.callback = null;
    }

    private boolean shouldFlush() {
        if (this.getSession().isTransactionInProgress()) {
            FlushMode effectiveFlushMode = this.getHibernateFlushMode();
            if (effectiveFlushMode == null) {
                effectiveFlushMode = this.getSession().getHibernateFlushMode();
            }
            if (effectiveFlushMode == FlushMode.ALWAYS) {
                return true;
            }
            if (effectiveFlushMode == FlushMode.AUTO && this.getSession().getFactory().getSessionFactoryOptions().isJpaBootstrap()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<R> doList() {
        return this.resolveSelectQueryPlan().performList(this);
    }

    private SelectQueryPlan<R> resolveSelectQueryPlan() {
        SelectInterpretationsKey cacheKey = this.generateSelectInterpretationsKey(this.resultSetMapping);
        if (cacheKey != null) {
            return this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan(cacheKey, () -> this.createQueryPlan(this.resultSetMapping));
        }
        return this.createQueryPlan(this.resultSetMapping);
    }

    private NativeSelectQueryPlan<R> createQueryPlan(final ResultSetMapping resultSetMapping) {
        final String sqlString = this.expandParameterLists();
        NativeSelectQueryDefinition queryDefinition = new NativeSelectQueryDefinition<R>(){

            @Override
            public String getSqlString() {
                return sqlString;
            }

            @Override
            public boolean isCallable() {
                return false;
            }

            @Override
            public List<ParameterOccurrence> getQueryParameterOccurrences() {
                return NativeQueryImpl.this.parameterOccurrences;
            }

            @Override
            public ResultSetMapping getResultSetMapping() {
                return resultSetMapping;
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return NativeQueryImpl.this.querySpaces;
            }
        };
        return this.getSessionFactory().getQueryEngine().getNativeQueryInterpreter().createQueryPlan(queryDefinition, this.getSessionFactory());
    }

    private String expandParameterLists() {
        if (this.parameterOccurrences == null || this.parameterOccurrences.isEmpty()) {
            return this.sqlString;
        }
        Dialect dialect = this.getSessionFactory().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
        boolean paddingEnabled = this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled();
        int inExprLimit = dialect.getInExpressionCountLimit();
        StringBuilder sb = null;
        int offset = 0;
        for (ParameterOccurrence occurrence : this.parameterOccurrences) {
            String expansionListAsString;
            char ch;
            int i;
            int sourcePosition;
            QueryParameterImplementor<?> queryParameter = occurrence.getParameter();
            QueryParameterBinding<?> binding = this.parameterBindings.getBinding(queryParameter);
            if (!binding.isMultiValued()) continue;
            Collection<?> bindValues = binding.getBindValues();
            int bindValueCount = bindValues.size();
            int bindValueMaxCount = NativeQueryImpl.determineBindValueMaxCount(paddingEnabled, inExprLimit, bindValueCount);
            if (inExprLimit > 0 && bindValueCount > inExprLimit) {
                log.tooManyInExpressions(dialect.getClass().getName(), inExprLimit, queryParameter.getName() == null ? queryParameter.getPosition().toString() : queryParameter.getName(), bindValueCount);
            }
            if ((sourcePosition = occurrence.getSourcePosition()) < 0) continue;
            boolean isEnclosedInParens = true;
            for (i = sourcePosition - 1; i >= 0; --i) {
                ch = this.sqlString.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                isEnclosedInParens = ch == '(';
                break;
            }
            if (isEnclosedInParens) {
                for (i = sourcePosition + 1; i < this.sqlString.length(); ++i) {
                    ch = this.sqlString.charAt(i);
                    if (Character.isWhitespace(ch)) continue;
                    isEnclosedInParens = ch == ')';
                    break;
                }
            }
            if (bindValueCount == 1 && isEnclosedInParens) continue;
            if (sb == null) {
                sb = new StringBuilder(this.sqlString.length() + 20);
                sb.append(this.sqlString);
            }
            if (bindValueMaxCount == 0) {
                expansionListAsString = isEnclosedInParens ? "null" : "(null)";
            } else {
                int index;
                int i2;
                char[] chars;
                if (isEnclosedInParens) {
                    chars = new char[(bindValueMaxCount << 1) - 1];
                    chars[0] = 63;
                    for (i2 = 1; i2 < bindValueMaxCount; ++i2) {
                        index = i2 << 1;
                        chars[index - 1] = 44;
                        chars[index] = 63;
                    }
                } else {
                    chars = new char[(bindValueMaxCount << 1) + 1];
                    chars[0] = 40;
                    chars[1] = 63;
                    for (i2 = 1; i2 < bindValueMaxCount; ++i2) {
                        index = i2 << 1;
                        chars[index] = 44;
                        chars[index + 1] = 63;
                    }
                    chars[chars.length - 1] = 41;
                }
                expansionListAsString = new String(chars);
            }
            int start = sourcePosition + offset;
            int end = start + 1;
            sb.replace(start, end, expansionListAsString);
            offset += expansionListAsString.length() - 1;
        }
        return sb == null ? this.sqlString : sb.toString();
    }

    public static int determineBindValueMaxCount(boolean paddingEnabled, int inExprLimit, int bindValueCount) {
        boolean inClauseParameterPaddingEnabled;
        int bindValueMaxCount = bindValueCount;
        boolean bl = inClauseParameterPaddingEnabled = paddingEnabled && bindValueCount > 2;
        if (inClauseParameterPaddingEnabled) {
            int bindValuePaddingCount = MathHelper.ceilingPowerOfTwo(bindValueCount);
            if (inExprLimit > 0 && bindValuePaddingCount > inExprLimit) {
                bindValuePaddingCount = inExprLimit;
            }
            if (bindValueCount < bindValuePaddingCount) {
                bindValueMaxCount = bindValuePaddingCount;
            }
        }
        return bindValueMaxCount;
    }

    private SelectInterpretationsKey generateSelectInterpretationsKey(JdbcValuesMappingProducer resultSetMapping) {
        if (!NativeQueryImpl.isCacheable(this)) {
            return null;
        }
        return new SelectInterpretationsKey(this.getQueryString(), resultSetMapping, this.getQueryOptions().getTupleTransformer(), this.getQueryOptions().getResultListTransformer());
    }

    private static boolean isCacheable(NativeQueryImpl<?> query) {
        return !query.parameterBindings.hasAnyMultiValuedBindings();
    }

    private static boolean hasLimit(Limit limit) {
        return limit.getFirstRow() != null || limit.getMaxRows() != null;
    }

    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        return this.resolveSelectQueryPlan().performScroll(scrollMode, this);
    }

    @Override
    protected int doExecuteUpdate() {
        return this.resolveNonSelectQueryPlan().executeUpdate(this);
    }

    private NonSelectQueryPlan resolveNonSelectQueryPlan() {
        NonSelectQueryPlan queryPlan = null;
        NonSelectInterpretationsKey cacheKey = this.generateNonSelectInterpretationsKey();
        if (cacheKey != null) {
            queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            String sqlString = this.expandParameterLists();
            queryPlan = new NativeNonSelectQueryPlanImpl(sqlString, this.querySpaces, this.parameterOccurrences);
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, queryPlan);
            }
        }
        return queryPlan;
    }

    protected NonSelectInterpretationsKey generateNonSelectInterpretationsKey() {
        if (!NativeQueryImpl.isCacheable(this)) {
            return null;
        }
        return new NonSelectInterpretationsKey(this.getQueryString(), this.getSynchronizedQuerySpaces());
    }

    @Override
    public NativeQueryImplementor setCollectionKey(Object key) {
        this.collectionKey = key;
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias) {
        return this.registerBuilder(Builders.scalar(columnAlias));
    }

    protected NativeQueryImplementor<R> registerBuilder(ResultBuilder builder) {
        this.resultSetMapping.addResultBuilder(builder);
        return this;
    }

    @Override
    public NativeQuery<R> addScalar(String columnAlias, BasicTypeReference<?> type) {
        return this.registerBuilder(Builders.scalar(columnAlias, this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().resolve(type)));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, BasicDomainType<?> type) {
        return this.registerBuilder(Builders.scalar(columnAlias, (BasicType)type));
    }

    @Override
    public NativeQueryImplementor<R> addScalar(String columnAlias, Class<?> javaType) {
        return this.registerBuilder(Builders.scalar(columnAlias, javaType, this.getSessionFactory()));
    }

    @Override
    public <C> NativeQueryImplementor<R> addScalar(String columnAlias, Class<C> jdbcJavaType, AttributeConverter<?, C> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, jdbcJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <O, J> NativeQueryImplementor<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, AttributeConverter<O, J> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, domainJavaType, jdbcJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <C> NativeQueryImplementor<R> addScalar(String columnAlias, Class<C> relationalJavaType, Class<? extends AttributeConverter<?, C>> converter) {
        return this.registerBuilder(Builders.converted(columnAlias, relationalJavaType, converter, this.getSessionFactory()));
    }

    @Override
    public <O, J> NativeQueryImplementor<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, Class<? extends AttributeConverter<O, J>> converterJavaType) {
        return this.registerBuilder(Builders.converted(columnAlias, domainJavaType, jdbcJavaType, converterJavaType, this.getSessionFactory()));
    }

    @Override
    public <J> NativeQuery.InstantiationResultNode<J> addInstantiation(Class<J> targetJavaType) {
        DynamicResultBuilderInstantiation<J> builder = Builders.instantiation(targetJavaType, this.getSessionFactory());
        this.registerBuilder(builder);
        return builder;
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, Class<?> entityJavaType, String attributePath) {
        return this.addAttributeResult(columnAlias, entityJavaType.getName(), attributePath);
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, String entityName, String attributePath) {
        this.registerBuilder(Builders.attributeResult(columnAlias, entityName, attributePath, this.getSessionFactory()));
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addAttributeResult(String columnAlias, SingularAttribute<?, ?> attribute) {
        this.registerBuilder(Builders.attributeResult(columnAlias, attribute));
        return this;
    }

    @Override
    public DynamicResultBuilderEntityStandard addRoot(String tableAlias, String entityName) {
        DynamicResultBuilderEntityStandard resultBuilder = Builders.entity(tableAlias, entityName, this.getSessionFactory());
        this.resultSetMapping.addResultBuilder(resultBuilder);
        return resultBuilder;
    }

    @Override
    public DynamicResultBuilderEntityStandard addRoot(String tableAlias, Class entityType) {
        return this.addRoot(tableAlias, entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String entityName) {
        return this.addEntity(StringHelper.unqualify(entityName), entityName);
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName) {
        this.registerBuilder(Builders.entityCalculated(tableAlias, entityName, this.getSessionFactory()));
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, String entityName, LockMode lockMode) {
        this.registerBuilder(Builders.entityCalculated(tableAlias, entityName, lockMode, this.getSessionFactory()));
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addEntity(Class<?> entityType) {
        return this.addEntity(entityType.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class<?> entityClass) {
        return this.addEntity(tableAlias, entityClass.getName());
    }

    @Override
    public NativeQueryImplementor<R> addEntity(String tableAlias, Class<?> entityClass, LockMode lockMode) {
        return this.addEntity(tableAlias, entityClass.getName(), lockMode);
    }

    @Override
    public NativeQuery.FetchReturn addFetch(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        DynamicFetchBuilderLegacy fetchBuilder = Builders.fetch(tableAlias, ownerTableAlias, joinPropertyName);
        this.resultSetMapping.addLegacyFetchBuilder(fetchBuilder);
        return fetchBuilder;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path) {
        this.createFetchJoin(tableAlias, path);
        return this;
    }

    private NativeQuery.FetchReturn createFetchJoin(String tableAlias, String path) {
        int loc = path.indexOf(46);
        if (loc < 0) {
            throw new QueryException("not a property path: " + path);
        }
        String ownerTableAlias = path.substring(0, loc);
        String joinedPropertyName = path.substring(loc + 1);
        return this.addFetch(tableAlias, ownerTableAlias, joinedPropertyName);
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.addFetch(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addJoin(String tableAlias, String path, LockMode lockMode) {
        this.createFetchJoin(tableAlias, path).setLockMode(lockMode);
        return this;
    }

    @Override
    public Collection<String> getSynchronizedQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedQuerySpace(String querySpace) {
        this.addQuerySpaces(querySpace);
        return this;
    }

    protected void addQuerySpaces(String ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, spaces);
        }
    }

    protected void addQuerySpaces(Serializable ... spaces) {
        if (spaces != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            Collections.addAll(this.querySpaces, (String[])spaces);
        }
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityName(String entityName) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityName).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addSynchronizedEntityClass(Class<?> entityClass) throws MappingException {
        this.addQuerySpaces(this.getSession().getFactory().getMetamodel().entityPersister(entityClass.getName()).getQuerySpaces());
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    public <T> T unwrap(Class<T> javaType) {
        if (javaType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (javaType.isAssignableFrom(ParameterMetadata.class)) {
            return (T)this.parameterMetadata;
        }
        if (javaType.isAssignableFrom(QueryParameterBindings.class)) {
            return (T)this.parameterBindings;
        }
        if (javaType.isAssignableFrom(EntityManager.class)) {
            return (T)this.getSession();
        }
        if (javaType.isAssignableFrom(EntityManagerFactory.class)) {
            return (T)this.getSession().getFactory();
        }
        throw new PersistenceException("Unrecognized unwrap type [" + javaType.getName() + "]");
    }

    @Override
    public NativeQueryImplementor<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        super.collectHints(hints);
        this.putIfNotNull(hints, "org.hibernate.lockMode", this.getLockOptions().getLockMode());
    }

    @Override
    protected boolean applySynchronizeSpacesHint(Object value) {
        if (value instanceof String) {
            this.addSynchronizedQuerySpace((String)value);
        } else if (value instanceof String[]) {
            String[] strings = (String[])value;
            for (int i = 0; i < strings.length; ++i) {
                this.addSynchronizedQuerySpace(strings[i]);
            }
        } else if (value instanceof Class) {
            this.addSynchronizedEntityClass((Class)value);
        } else if (value instanceof Class[]) {
            Class[] classes = (Class[])value;
            for (int i = 0; i < classes.length; ++i) {
                this.addSynchronizedEntityClass(classes[i]);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            list.forEach(this::applySynchronizeSpacesHint);
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object element : values) {
                this.applySynchronizeSpacesHint(element);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected boolean applyNativeQueryLockMode(Object value) {
        if (value instanceof LockMode) {
            this.applyHibernateLockModeHint((LockMode)((Object)value));
        } else if (value instanceof LockModeType) {
            this.applyLockModeTypeHint((LockModeType)value);
        } else if (String.class.isInstance(value)) {
            this.applyHibernateLockModeHint(LockModeTypeHelper.interpretLockMode(value));
        } else {
            throw new IllegalArgumentException(String.format("Native lock-mode hint [%s] must specify %s or %s.  Encountered type : %s", "org.hibernate.lockMode", LockMode.class.getName(), LockModeType.class.getName(), value.getClass().getName()));
        }
        return true;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter((QueryParameter)parameter, (Object)value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter((Parameter)parameter, (Object)value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        super.setParameter((QueryParameter)parameter, (Object)value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Object value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Object value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, AllowableParameterType<P> type) {
        super.setParameterList(name, (Collection)values, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, AllowableParameterType<P> type) {
        super.setParameterList(position, (Collection)values, (AllowableParameterType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values, AllowableParameterType<?> type) {
        super.setParameterList(name, values, (AllowableParameterType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values, AllowableParameterType<?> type) {
        super.setParameterList(position, values, (AllowableParameterType)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<P> values) {
        super.setParameterList((QueryParameter)parameter, (Collection)values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Collection<?> values) {
        super.setParameterList(name, (Collection)values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P value, AllowableParameterType<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(String name, P value, AllowableParameterType<P> type) {
        super.setParameter(name, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(int position, P value, AllowableParameterType<P> type) {
        super.setParameter(position, (Object)value, (AllowableParameterType)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(String name, P value, BasicTypeReference<P> type) {
        super.setParameter(name, (Object)value, (BasicTypeReference)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(int position, P value, BasicTypeReference<P> type) {
        super.setParameter(position, (Object)value, (BasicTypeReference)type);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameter(QueryParameter<P> parameter, P val, BasicTypeReference<P> type) {
        super.setParameter((QueryParameter)parameter, (Object)val, (BasicTypeReference)type);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Collection<?> values) {
        super.setParameterList(position, (Collection)values);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public <P> NativeQueryImplementor<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, (Collection)values, (Class)javaType);
        return this;
    }

    @Override
    public NativeQueryImplementor<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    protected void applyEntityGraphQueryHint(String hintName, RootGraphImplementor entityGraph) {
        throw new HibernateException("A native SQL query cannot use EntityGraphs");
    }

    private static class ParameterInterpretationImpl
    implements ParameterInterpretation {
        private final String sqlString;
        private final List<ParameterOccurrence> parameterList;
        private final Map<Integer, QueryParameterImplementor<?>> positionalParameters;
        private final Map<String, QueryParameterImplementor<?>> namedParameters;

        public ParameterInterpretationImpl(String sqlString, ParameterRecognizerImpl parameterRecognizer) {
            this.sqlString = parameterRecognizer.getAdjustedSqlString();
            this.parameterList = parameterRecognizer.getParameterList();
            this.positionalParameters = parameterRecognizer.getPositionalQueryParameters();
            this.namedParameters = parameterRecognizer.getNamedQueryParameters();
        }

        @Override
        public List<ParameterOccurrence> getOrderedParameterOccurrences() {
            return this.parameterList;
        }

        @Override
        public ParameterMetadataImplementor toParameterMetadata(SharedSessionContractImplementor session1) {
            return new ParameterMetadataImpl(this.positionalParameters, this.namedParameters);
        }

        @Override
        public String getAdjustedSqlString() {
            return this.sqlString;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("ParameterInterpretationImpl (").append(this.sqlString).append(") : {");
            int size = this.parameterList.size();
            for (int i = 0; i < size; ++i) {
                buffer.append(System.lineSeparator()).append("    ");
                if (i == size - 1) continue;
                buffer.append(",");
            }
            return buffer.append(System.lineSeparator()).append("}").toString();
        }
    }

    @FunctionalInterface
    private static interface ResultSetMappingHandler {
        public boolean resolveResultSetMapping(ResultSetMappingImpl var1, Consumer<String> var2, ResultSetMappingResolutionContext var3);
    }
}

