/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmAggregateFunction;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class SelfRenderingSqmAggregateFunction<T>
extends SelfRenderingSqmFunction<T>
implements SqmAggregateFunction<T> {
    private final SqmPredicate filter;

    public SelfRenderingSqmAggregateFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, AllowableFunctionReturnType<T> impliedResultType, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
        super(descriptor, renderingSupport, arguments, impliedResultType, returnTypeResolver, nodeBuilder, name);
        this.filter = filter;
    }

    @Override
    public SelfRenderingFunctionSqlAstExpression convertToSqlAst(SqmToSqlAstConverter walker) {
        AllowableFunctionReturnType<?> resultType = this.resolveResultType(walker.getCreationContext().getDomainModel().getTypeConfiguration());
        return new SelfRenderingAggregateFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), SelfRenderingSqmAggregateFunction.resolveSqlAstArguments(this.getArguments(), walker), this.filter == null ? null : (Predicate)this.filter.accept(walker), resultType, this.getMappingModelExpressable(walker, resultType));
    }

    @Override
    public SqmPredicate getFilter() {
        return this.filter;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        List<SqmTypedNode<?>> arguments = this.getArguments();
        sb.append(this.getFunctionName());
        sb.append('(');
        int i = 1;
        if (arguments.get(0) instanceof SqmDistinct) {
            ((SqmSelectableNode)arguments.get(0)).appendHqlString(sb);
            sb.append(' ');
            ((SqmSelectableNode)arguments.get(1)).appendHqlString(sb);
            i = 2;
        }
        while (i < arguments.size()) {
            sb.append(", ");
            ((SqmSelectableNode)arguments.get(i)).appendHqlString(sb);
            ++i;
        }
        sb.append(')');
        if (this.filter != null) {
            sb.append(" filter (where ");
            this.filter.appendHqlString(sb);
            sb.append(')');
        }
    }
}

