/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.Map;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelHelper;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class SimpleDeleteQueryPlan
implements NonSelectQueryPlan {
    private final EntityMappingType entityDescriptor;
    private final SqmDeleteStatement sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private JdbcDelete jdbcDelete;
    private SqmTranslation<DeleteStatement> sqmInterpretation;
    private Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamsXref;

    public SimpleDeleteQueryPlan(EntityMappingType entityDescriptor, SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref) {
        assert (entityDescriptor.getEntityName().equals(((SqmRoot)sqmDelete.getTarget()).getEntityName()));
        this.entityDescriptor = entityDescriptor;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
    }

    private SqlAstTranslator<JdbcDelete> createDeleteTranslator(DomainQueryExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        QueryEngine queryEngine = factory.getQueryEngine();
        SqmTranslatorFactory translatorFactory = queryEngine.getSqmTranslatorFactory();
        SqmTranslator<DeleteStatement> translator = translatorFactory.createSimpleDeleteTranslator(this.sqmDelete, executionContext.getQueryOptions(), this.domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), factory);
        this.sqmInterpretation = translator.translate();
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(this.domainParameterXref, this.sqmInterpretation::getJdbcParamsBySqmParam);
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(factory, this.sqmInterpretation.getSqlAst());
    }

    @Override
    public int executeUpdate(DomainQueryExecutionContext executionContext) {
        boolean missingRestriction;
        BulkOperationCleanupAction.schedule(executionContext.getSession(), this.sqmDelete);
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcDelete> deleteTranslator = null;
        if (this.jdbcDelete == null) {
            deleteTranslator = this.createDeleteTranslator(executionContext);
        }
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, factory.getDomainModel(), this.sqmInterpretation.getFromClauseAccess()::findTableGroup, this.sqmInterpretation.getSqmParameterMappingModelTypeResolutions()::get, session);
        if (this.jdbcDelete != null && !this.jdbcDelete.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
            deleteTranslator = this.createDeleteTranslator(executionContext);
        }
        if (deleteTranslator != null) {
            this.jdbcDelete = deleteTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        } else {
            this.jdbcDelete.bindFilterJdbcParameters(jdbcParameterBindings);
        }
        boolean bl = missingRestriction = this.sqmDelete.getWhereClause() == null || this.sqmDelete.getWhereClause().getPredicate() == null;
        if (missingRestriction) {
            assert (this.domainParameterXref.getSqmParameterCount() == 0);
            assert (this.jdbcParamsXref.isEmpty());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.usingLockingAndPaging(executionContext);
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (missingRestriction) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            Expression fkColumnExpression = MappingModelHelper.buildColumnReferenceExpression(fkDescriptor.getKeyPart(), null, factory);
            QuerySpec matchingIdSubQuery = new QuerySpec(false);
            MutatingTableReferenceGroupWrapper tableGroup = new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, this.sqmInterpretation.getSqlAst().getTargetTable());
            Expression fkTargetColumnExpression = MappingModelHelper.buildColumnReferenceExpression(tableGroup, fkDescriptor.getTargetPart(), this.sqmInterpretation.getSqlExpressionResolver(), factory);
            matchingIdSubQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, fkTargetColumnExpression));
            matchingIdSubQuery.getFromClause().addRoot(tableGroup);
            matchingIdSubQuery.applyPredicate(this.sqmInterpretation.getSqlAst().getRestriction());
            return new InSubQueryPredicate(fkColumnExpression, matchingIdSubQuery, false);
        }, missingRestriction ? JdbcParameterBindings.NO_BINDINGS : jdbcParameterBindings, executionContextAdapter);
        return jdbcServices.getJdbcMutationExecutor().execute(this.jdbcDelete, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContextAdapter);
    }
}

