/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import org.hibernate.LockOptions;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.internal.QuerySqmImpl;

public class SqmInterpretationsKey
implements QueryInterpretationCache.Key {
    private final String query;
    private final Class<?> resultType;
    private final LockOptions lockOptions;
    private final TupleTransformer<?> tupleTransformer;
    private final ResultListTransformer resultListTransformer;

    public static SqmInterpretationsKey generateFrom(QuerySqmImpl<?> query) {
        if (!SqmInterpretationsKey.isCacheable(query)) {
            return null;
        }
        return new SqmInterpretationsKey(query.getQueryString(), query.getResultType(), query.getLockOptions(), query.getQueryOptions().getTupleTransformer(), query.getQueryOptions().getResultListTransformer());
    }

    public static QueryInterpretationCache.Key generateNonSelectKey(QuerySqmImpl<?> query) {
        return null;
    }

    private static boolean isCacheable(QuerySqmImpl<?> query) {
        assert (query.getQueryOptions().getAppliedGraph() != null);
        if ("<criteria>".equals(query.getQueryString())) {
            return false;
        }
        if (query.getSession().getLoadQueryInfluencers().hasEnabledFilters()) {
            return false;
        }
        if (query.getQueryOptions().getAppliedGraph().getSemantic() != null) {
            return false;
        }
        return !query.getQueryParameterBindings().hasAnyMultiValuedBindings() && !query.getParameterMetadata().hasAnyMatching(QueryParameter::allowsMultiValuedBinding);
    }

    private SqmInterpretationsKey(String query, Class<?> resultType, LockOptions lockOptions, TupleTransformer<?> tupleTransformer, ResultListTransformer resultListTransformer) {
        this.query = query;
        this.resultType = resultType;
        this.lockOptions = lockOptions;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new SqmInterpretationsKey(this.query, this.resultType, this.lockOptions.makeCopy(), this.tupleTransformer, this.resultListTransformer);
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqmInterpretationsKey that = (SqmInterpretationsKey)o;
        return this.query.equals(that.query) && this.areEqual(this.resultType, that.resultType) && this.areEqual(this.lockOptions, that.lockOptions) && this.areEqual(this.tupleTransformer, that.tupleTransformer) && this.areEqual(this.resultListTransformer, that.resultListTransformer);
    }

    private <T> boolean areEqual(T o1, T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + (this.resultType != null ? this.resultType.hashCode() : 0);
        result = 31 * result + (this.lockOptions != null ? this.lockOptions.hashCode() : 0);
        result = 31 * result + (this.tupleTransformer != null ? this.tupleTransformer.hashCode() : 0);
        result = 31 * result + (this.resultListTransformer != null ? this.resultListTransformer.hashCode() : 0);
        return result;
    }
}

