/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteStrategy;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.graph.basic.BasicResult;

public class CteDeleteHandler
extends AbstractCteMutationHandler
implements DeleteHandler {
    protected CteDeleteHandler(SqmCteTable cteTable, SqmDeleteStatement<?> sqmDeleteStatement, DomainParameterXref domainParameterXref, CteStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmDeleteStatement, domainParameterXref, strategy, sessionFactory);
    }

    @Override
    protected void addDmlCtes(CteContainer statement, CteStatement idSelectCte, MultiTableSqmMutationConverter sqmConverter, Map<SqmParameter, List<JdbcParameter>> parameterResolutions, SessionFactoryImplementor factory) {
        TableGroup updatingTableGroup = sqmConverter.getMutatingTableGroup();
        SelectStatement idSelectStatement = (SelectStatement)idSelectCte.getCteDefinition();
        sqmConverter.getProcessingStateStack().push(new SqlAstQueryPartProcessingStateImpl(idSelectStatement.getQuerySpec(), sqmConverter.getCurrentProcessingState(), sqmConverter.getSqlAstCreationState(), sqmConverter.getCurrentClauseStack()::getCurrent));
        this.getEntityDescriptor().visitSubTypeAttributeMappings(attribute -> {
            PluralAttributeMapping pluralAttribute;
            if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                boolean useFkTarget;
                boolean bl = useFkTarget = !(pluralAttribute.getKeyDescriptor().getTargetPart() instanceof EntityIdentifierMapping);
                if (useFkTarget) {
                    TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
                    pluralAttribute.getKeyDescriptor().getTargetPart().applySqlSelections(mutatingTableGroup.getNavigablePath(), mutatingTableGroup, sqmConverter, (selection, jdbcMapping) -> idSelectStatement.getDomainResultDescriptors().add(new BasicResult(selection.getValuesArrayPosition(), null, jdbcMapping.getJavaTypeDescriptor())));
                }
                String tableExpression = pluralAttribute.getSeparateCollectionTable();
                CteTable dmlResultCte = new CteTable(this.getCteTableName(pluralAttribute), idSelectCte.getCteTable().getCteColumns(), factory);
                TableReference dmlTableReference = new TableReference(tableExpression, null, true, factory);
                ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
                pluralAttribute.getKeyDescriptor().visitKeySelectables((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable, factory)));
                DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, useFkTarget ? pluralAttribute.getKeyDescriptor().getTargetPart() : null, factory), columnReferences);
                statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
            }
        });
        sqmConverter.getProcessingStateStack().pop();
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> {
            CteTable dmlResultCte = new CteTable(this.getCteTableName(tableExpression), idSelectCte.getCteTable().getCteColumns(), factory);
            TableReference dmlTableReference = this.resolveUnionTableReference(updatingTableGroup, tableExpression);
            ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>(idSelectCte.getCteTable().getCteColumns().size());
            ((Consumer)tableColumnsVisitationSupplier.get()).accept((index, selectable) -> columnReferences.add(new ColumnReference(dmlTableReference, selectable, factory)));
            DeleteStatement dmlStatement = new DeleteStatement(dmlTableReference, this.createIdSubQueryPredicate(columnReferences, idSelectCte, factory), columnReferences);
            statement.addCteStatement(new CteStatement(dmlResultCte, dmlStatement));
        });
    }

    protected String getCteTableName(PluralAttributeMapping pluralAttribute) {
        String hibernateEntityName = pluralAttribute.findContainingEntityMapping().getEntityName();
        String jpaEntityName = this.getSessionFactory().getJpaMetamodel().entity(hibernateEntityName).getName();
        return "dml_cte_" + jpaEntityName + "_" + pluralAttribute.getRootPathName().substring(hibernateEntityName.length() + 1);
    }
}

