/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteUpdateHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class CteStrategy
implements SqmMultiTableMutationStrategy {
    public static final String SHORT_NAME = "cte";
    public static final String TABLE_NAME = "id_cte";
    private final EntityPersister rootDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final SqmCteTable cteTable;

    public CteStrategy(EntityMappingType rootEntityType, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityType.getEntityPersister(), runtimeModelCreationContext);
    }

    public CteStrategy(EntityPersister rootDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.rootDescriptor = rootDescriptor;
        this.sessionFactory = runtimeModelCreationContext.getSessionFactory();
        Dialect dialect = this.sessionFactory.getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
        if (!dialect.supportsNonQueryWithCTE()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support CTE that can take UPDATE or DELETE statements as well");
        }
        if (!dialect.supportsValuesList()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support VALUES lists");
        }
        this.cteTable = new SqmCteTable(TABLE_NAME, rootDescriptor);
    }

    @Override
    public int executeDelete(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch(sqmDelete);
        return new CteDeleteHandler(this.cteTable, sqmDelete, domainParameterXref, this, this.sessionFactory).execute(context);
    }

    @Override
    public int executeUpdate(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch(sqmUpdate);
        return new CteUpdateHandler(this.cteTable, sqmUpdate, domainParameterXref, this, this.sessionFactory).execute(context);
    }

    private void checkMatch(SqmDeleteOrUpdateStatement sqmStatement) {
        String targetEntityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister targetEntityDescriptor = this.sessionFactory.getDomainModel().getEntityDescriptor(targetEntityName);
        if (targetEntityDescriptor != this.rootDescriptor && !this.rootDescriptor.isSubclassEntityName(targetEntityDescriptor.getEntityName())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Target of query [%s] did not match configured entity [%s]", targetEntityName, this.rootDescriptor.getEntityName()));
        }
    }
}

