/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Contributable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableColumn;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableSessionUidColumn;

public class IdTable
implements Exportable,
Contributable {
    public static final String DEFAULT_ALIAS = "idtable_";
    private final EntityMappingType entityDescriptor;
    private final String qualifiedTableName;
    private IdTableSessionUidColumn sessionUidColumn;
    private final List<IdTableColumn> columns = new ArrayList<IdTableColumn>();
    private final Dialect dialect;

    public IdTable(EntityMappingType entityDescriptor, Function<String, String> idTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.entityDescriptor = entityDescriptor;
        String originalTableName = entityDescriptor.getEntityPersister().getSynchronizedQuerySpaces()[0];
        this.qualifiedTableName = Identifier.isQuoted(originalTableName) ? dialect.quote(idTableNameAdjuster.apply(Identifier.unQuote(originalTableName))) : idTableNameAdjuster.apply(originalTableName);
        PersistentClass entityBinding = runtimeModelCreationContext.getBootModel().getEntityBinding(entityDescriptor.getEntityName());
        Iterator<Column> itr = entityBinding.getTable().getPrimaryKey().getColumnIterator();
        Iterator<JdbcMapping> jdbcMappings = entityDescriptor.getIdentifierMapping().getJdbcMappings().iterator();
        while (itr.hasNext()) {
            Column column = itr.next();
            JdbcMapping jdbcMapping = jdbcMappings.next();
            this.columns.add(new IdTableColumn(this, column.getText(dialect), jdbcMapping, column.getSqlType(dialect, runtimeModelCreationContext.getMetadata())));
        }
        entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
            ModelPart fkTarget;
            PluralAttributeMapping pluralAttribute;
            if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null && !((fkTarget = pluralAttribute.getKeyDescriptor().getTargetPart()) instanceof EntityIdentifierMapping)) {
                Value value = entityBinding.getSubclassProperty(pluralAttribute.getAttributeName()).getValue();
                Iterator<Selectable> columnIterator = ((Collection)value).getKey().getColumnIterator();
                fkTarget.forEachSelectable((columnIndex, selection) -> {
                    Selectable selectable = (Selectable)columnIterator.next();
                    if (selectable instanceof Column) {
                        this.columns.add(new IdTableColumn(this, selectable.getText(dialect), selection.getJdbcMapping(), ((Column)selectable).getSqlType(dialect, runtimeModelCreationContext.getMetadata())));
                    }
                });
            }
        });
        this.dialect = dialect;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public List<IdTableColumn> getIdTableColumns() {
        return this.columns;
    }

    public IdTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    public String getTableExpression() {
        return this.qualifiedTableName;
    }

    public void addColumn(IdTableColumn column) {
        this.columns.add(column);
        if (column instanceof IdTableSessionUidColumn) {
            this.sessionUidColumn = (IdTableSessionUidColumn)column;
        }
    }

    @Override
    public String getContributor() {
        return this.entityDescriptor.getContributor();
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName();
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

