/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableHelper;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.jboss.logging.Logger;

public class PersistentTableStrategy
implements SqmMultiTableMutationStrategy {
    private static final Logger log = Logger.getLogger(PersistentTableStrategy.class);
    public static final String SHORT_NAME = "persistent";
    public static final String DROP_ID_TABLES = "hibernate.hql.bulk_id_strategy.persistent.drop_tables";
    public static final String SCHEMA = "hibernate.hql.bulk_id_strategy.persistent.schema";
    public static final String CATALOG = "hibernate.hql.bulk_id_strategy.persistent.catalog";
    private final IdTable idTable;
    private final AfterUseAction afterUseAction;
    private final Supplier<IdTableExporter> idTableExporterAccess;
    private final SessionFactoryImplementor sessionFactory;
    private boolean prepared;
    private boolean created;
    private boolean released;

    public PersistentTableStrategy(IdTable idTable, AfterUseAction afterUseAction, Supplier<IdTableExporter> idTableExporterAccess, SessionFactoryImplementor sessionFactory) {
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.idTableExporterAccess = idTableExporterAccess;
        this.sessionFactory = sessionFactory;
        if (afterUseAction == AfterUseAction.DROP) {
            throw new IllegalArgumentException("Persistent ID tables cannot use AfterUseAction.DROP : " + idTable.getTableExpression());
        }
    }

    @Override
    public int executeUpdate(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new TableBasedUpdateHandler(sqmUpdate, domainParameterXref, this.idTable, session -> session.getSessionIdentifier().toString(), this.idTableExporterAccess, BeforeUseAction.CREATE, this.afterUseAction, TempTableDdlTransactionHandling.NONE, this.sessionFactory).execute(context);
    }

    @Override
    public int executeDelete(SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new TableBasedDeleteHandler(sqmDelete, domainParameterXref, this.idTable, session -> session.getSessionIdentifier().toString(), this.idTableExporterAccess, BeforeUseAction.CREATE, this.afterUseAction, TempTableDdlTransactionHandling.NONE, this.sessionFactory).execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(MappingModelCreationProcess mappingModelCreationProcess, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        log.debugf("Creating persistent ID table : %s", (Object)this.idTable.getTableExpression());
        IdTableHelper.IdTableCreationWork idTableCreationWork = new IdTableHelper.IdTableCreationWork(this.idTable, this.idTableExporterAccess.get(), this.sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debug((Object)"Unable to obtain JDBC connection; assuming ID tables already exist or wont be needed");
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", (Throwable)e);
            return;
        }
        try {
            idTableCreationWork.execute(connection);
            this.created = true;
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
        if (this.created) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(SessionFactoryImplementor sessionFactory, JdbcConnectionAccess connectionAccess) {
        Connection connection;
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.created) {
            return;
        }
        log.debugf("Dropping persistent ID table : %s", (Object)this.idTable.getTableExpression());
        IdTableHelper.IdTableDropWork idTableDropWork = new IdTableHelper.IdTableDropWork(this.idTable, this.idTableExporterAccess.get(), sessionFactory);
        try {
            connection = connectionAccess.obtainConnection();
        }
        catch (UnsupportedOperationException e) {
            log.debugf("Unable to obtain JDBC connection; unable to drop persistent ID table : %s", (Object)this.idTable.getTableExpression());
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Unable obtain JDBC Connection", (Throwable)e);
            return;
        }
        try {
            idTableDropWork.execute(connection);
        }
        finally {
            try {
                connectionAccess.releaseConnection(connection);
            }
            catch (SQLException sQLException) {}
        }
    }
}

