/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.UpdateExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.jboss.logging.Logger;

public class TableBasedUpdateHandler
extends AbstractMutationHandler
implements UpdateHandler {
    private static final Logger log = Logger.getLogger(TableBasedUpdateHandler.class);
    private final IdTable idTable;
    private final TempTableDdlTransactionHandling ddlTransactionHandling;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final Supplier<IdTableExporter> exporterSupplier;
    private final DomainParameterXref domainParameterXref;
    private final EntityPersister entityDescriptor;

    TableBasedUpdateHandler(SqmUpdateStatement sqmUpdate, DomainParameterXref domainParameterXref, IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, Supplier<IdTableExporter> exporterSupplier, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, TempTableDdlTransactionHandling ddlTransactionHandling, SessionFactoryImplementor sessionFactory) {
        super(sqmUpdate, sessionFactory);
        this.idTable = idTable;
        this.exporterSupplier = exporterSupplier;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.ddlTransactionHandling = ddlTransactionHandling;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        String targetEntityName = ((SqmRoot)sqmUpdate.getTarget()).getEntityName();
        this.entityDescriptor = sessionFactory.getDomainModel().getEntityDescriptor(targetEntityName);
    }

    protected SqmUpdateStatement getSqmUpdate() {
        return this.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public SqmUpdateStatement getSqmDeleteOrUpdateStatement() {
        return (SqmUpdateStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table update execution - %s", (Object)this.getSqmDeleteOrUpdateStatement().getRoot().getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        return this.resolveDelegate(executionContext).execute(executionContextAdapter);
    }

    private ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        Predicate predicate;
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        MappingMetamodel domainModel = sessionFactory.getDomainModel();
        EntityPersister entityDescriptor = domainModel.getEntityDescriptor(((SqmRoot)this.getSqmDeleteOrUpdateStatement().getTarget()).getEntityName());
        String rootEntityName = entityDescriptor.getRootEntityName();
        EntityPersister rootEntityDescriptor = domainModel.getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = ((Joinable)((Object)rootEntityDescriptor)).getTableName();
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, this.getSqmDeleteOrUpdateStatement(), (SqmRoot<?>)this.getSqmDeleteOrUpdateStatement().getTarget(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), sessionFactory);
        TableGroup updatingTableGroup = converterDelegate.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Map<SqmParameter, List<List<JdbcParameter>>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        LinkedHashMap<SqmParameter, MappingModelExpressable> paramTypeResolutions = new LinkedHashMap<SqmParameter, MappingModelExpressable>();
        converterDelegate.visitSetClause(this.getSqmDeleteOrUpdateStatement().getSetClause(), assignments::add, (sqmParameter, mappingType, jdbcParameters) -> {
            parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
            paramTypeResolutions.put(sqmParameter, mappingType);
        });
        converterDelegate.addVersionedAssignment(assignments::add, this.getSqmDeleteOrUpdateStatement());
        SqmWhereClause whereClause = this.getSqmUpdate().getWhereClause();
        if (whereClause == null || whereClause.getPredicate() == null) {
            predicate = null;
        } else {
            predicate = converterDelegate.visitWhereClause(whereClause, columnReference -> {}, (sqmParameter, mappingType, jdbcParameters) -> {
                parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
                paramTypeResolutions.put(sqmParameter, mappingType);
            });
            assert (predicate != null);
        }
        FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(executionContext.getSession().getLoadQueryInfluencers(), (Joinable)((Object)rootEntityDescriptor), updatingTableGroup);
        if (filterPredicate != null) {
            predicate = SqlAstTreeHelper.combinePredicates(predicate, filterPredicate);
        }
        converterDelegate.pruneTableGroupJoins();
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        return new UpdateExecutionDelegate(this.getSqmUpdate(), converterDelegate, this.idTable, this.ddlTransactionHandling, this.beforeUseAction, this.afterUseAction, this.sessionUidAccess, this.exporterSupplier, this.domainParameterXref, updatingTableGroup, hierarchyRootTableReference, tableReferenceByAlias, assignments, predicate, parameterResolutions, paramTypeResolutions, executionContext);
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

