/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.StatementCreatorHelper;

public class InlineDeleteHandler
implements DeleteHandler {
    private final MatchingIdRestrictionProducer matchingIdsPredicateProducer;
    private final SqmDeleteStatement sqmDeleteStatement;
    private final DomainParameterXref domainParameterXref;
    private final DomainQueryExecutionContext executionContext;
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAstTranslatorFactory sqlAstTranslatorFactory;
    private final JdbcMutationExecutor jdbcMutationExecutor;

    protected InlineDeleteHandler(MatchingIdRestrictionProducer matchingIdsPredicateProducer, SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.sqmDeleteStatement = sqmDeleteStatement;
        this.domainParameterXref = domainParameterXref;
        this.matchingIdsPredicateProducer = matchingIdsPredicateProducer;
        this.executionContext = context;
        this.sessionFactory = this.executionContext.getSession().getFactory();
        this.sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        this.jdbcMutationExecutor = this.sessionFactory.getJdbcServices().getJdbcMutationExecutor();
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        List<Object> idsAndFks = MatchingIdSelectionHelper.selectMatchingIds(this.sqmDeleteStatement, this.domainParameterXref, executionContext);
        if (idsAndFks == null || idsAndFks.isEmpty()) {
            return 0;
        }
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        String mutatingEntityName = ((SqmRoot)this.sqmDeleteStatement.getTarget()).getModel().getHibernateEntityName();
        EntityPersister entityDescriptor = factory.getDomainModel().getEntityDescriptor(mutatingEntityName);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.domainParameterXref.getQueryParameterCount());
        MutableInteger valueIndexCounter = new MutableInteger();
        entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
            PluralAttributeMapping pluralAttribute;
            if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                int valueIndex;
                ModelPart fkTargetPart = pluralAttribute.getKeyDescriptor().getTargetPart();
                if (fkTargetPart instanceof EntityIdentifierMapping) {
                    valueIndex = 0;
                } else {
                    if (valueIndexCounter.get() == 0) {
                        valueIndexCounter.set(entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
                    }
                    valueIndex = valueIndexCounter.get();
                    valueIndexCounter.plus(fkTargetPart.getJdbcTypeCount());
                }
                this.executeDelete(pluralAttribute.getSeparateCollectionTable(), entityDescriptor, () -> fkTargetPart::forEachSelectable, idsAndFks, valueIndex, fkTargetPart, jdbcParameterBindings, executionContext);
            }
        });
        entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> this.executeDelete(tableExpression, entityDescriptor, tableKeyColumnsVisitationSupplier, idsAndFks, 0, null, jdbcParameterBindings, executionContext));
        return idsAndFks.size();
    }

    private void executeDelete(String targetTableExpression, EntityMappingType entityDescriptor, Supplier<Consumer<SelectableConsumer>> tableKeyColumnsVisitationSupplier, List<Object> ids, int valueIndex, ModelPart valueModelPart, JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext executionContext) {
        TableReference targetTableReference = new TableReference(targetTableExpression, "to_delete_", false, this.sessionFactory);
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        Predicate matchingIdsPredicate = this.matchingIdsPredicateProducer.produceRestriction(ids, entityDescriptor, valueIndex, valueModelPart, targetTableReference, tableKeyColumnsVisitationSupplier, executionContextAdapter);
        DeleteStatement deleteStatement = new DeleteStatement(targetTableReference, matchingIdsPredicate);
        JdbcDelete jdbcOperation = this.sqlAstTranslatorFactory.buildDeleteTranslator(this.sessionFactory, deleteStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        this.jdbcMutationExecutor.execute(jdbcOperation, jdbcParameterBindings, this::prepareQueryStatement, (integer, preparedStatement) -> {}, executionContextAdapter);
    }

    private PreparedStatement prepareQueryStatement(String sql) {
        return StatementCreatorHelper.prepareQueryStatement(sql, this.executionContext.getSession());
    }
}

