/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class DiscriminatorPathInterpretation
extends AbstractSqmPathInterpretation
implements DomainResultProducer {
    private final Expression expression;

    public DiscriminatorPathInterpretation(NavigablePath navigablePath, EntityMappingType mapping, TableGroup tableGroup, SqlAstCreationState sqlAstCreationState) {
        super(navigablePath, mapping.getDiscriminatorMapping(), tableGroup);
        JdbcMapping jdbcMappingToUse = mapping.getDiscriminatorMapping().getJdbcMapping();
        this.expression = this.getDiscriminatorMapping().resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, sqlAstCreationState);
    }

    public EntityDiscriminatorMapping getDiscriminatorMapping() {
        return (EntityDiscriminatorMapping)super.getExpressionType();
    }

    @Override
    public EntityDiscriminatorMapping getExpressionType() {
        return this.getDiscriminatorMapping();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaType javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(valuesArrayPosition, this.getDiscriminatorMapping());
    }

    public DomainResult<Class<?>> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getDiscriminatorMapping().createDomainResult(this.getNavigablePath(), this.getTableGroup(), resultVariable, creationState);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }
}

