/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;

public class NonAggregatedCompositeSimplePath<T>
extends SqmEntityValuedSimplePath<T> {
    public NonAggregatedCompositeSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        assert (referencedPathSource.getSqmPathType() instanceof EntityType);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitNonAggregatedCompositeValuedPath(this);
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new PathException("Non Aggregate composite paths cannot be TREAT-ed");
    }
}

