/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmEmbeddedValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements AllowableParameterType<T> {
    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        assert (referencedPathSource.getSqmPathType() instanceof EmbeddableDomainType);
    }

    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
        assert (referencedPathSource.getSqmPathType() instanceof EmbeddableDomainType);
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEmbeddableValuedPath(this);
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        throw new PathException("Embeddable paths cannot be TREAT-ed");
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new PathException("Embeddable paths cannot be TREAT-ed");
    }

    @Override
    public JavaType<T> getExpressableJavaTypeDescriptor() {
        return this.getJavaTypeDescriptor();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }
}

