/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmIndexedCollectionAccessPath<T>
extends AbstractSqmPath<T>
implements SqmPath<T> {
    private final SqmExpression<?> selectorExpression;

    public SqmIndexedCollectionAccessPath(NavigablePath navigablePath, SqmPath<?> pluralDomainPath, SqmExpression<?> selectorExpression) {
        super(navigablePath, ((PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource()).getElementPathSource(), pluralDomainPath, pluralDomainPath.nodeBuilder());
        this.selectorExpression = selectorExpression;
    }

    public SqmExpression<?> getSelectorExpression() {
        return this.selectorExpression;
    }

    public PluralPersistentAttribute<?, ?, T> getPluralAttribute() {
        return (PluralPersistentAttribute)this.getLhs().getReferencedPathSource();
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitIndexedPluralAccessPath(this);
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        if (this.getReferencedPathSource().getSqmPathType() instanceof EntityDomainType) {
            return new SqmTreatedSimplePath(this, treatTarget, (NodeBuilder)this.nodeBuilder());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.getLhs().appendHqlString(sb);
        sb.append('[');
        this.selectorExpression.appendHqlString(sb);
        sb.append(']');
    }
}

