/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;

public class SqmTreatedSetJoin<O, T, S extends T>
extends SqmSetJoin<O, S>
implements SqmTreatedPath<T, S> {
    private final SqmSetJoin<O, T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedSetJoin(SqmSetJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), wrappedPath.isFetched(), (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public void addSqmJoin(SqmJoin<S, ?> join) {
        super.addSqmJoin(join);
        this.wrappedPath.addSqmJoin(join);
    }

    public SqmSetJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SetPersistentAttribute<O, S> getModel() {
        return super.getModel();
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SetPersistentAttribute<O, S> getReferencedPathSource() {
        return super.getReferencedPathSource();
    }

    @Override
    public SqmAttributeJoin<O, S> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmTreatedSetJoin<O, T, S>(this.wrappedPath, this.treatTarget, this.getAlias());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

