/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public abstract class AbstractSqmParameter<T>
extends AbstractSqmExpression<T>
implements SqmParameter<T> {
    private final boolean canBeMultiValued;

    public AbstractSqmParameter(boolean canBeMultiValued, AllowableParameterType<T> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.canBeMultiValued = canBeMultiValued;
    }

    @Override
    public void applyInferableType(SqmExpressable<?> type) {
        SqmExpressable oldType;
        SqmExpressable newType;
        if (type == null) {
            return;
        }
        if (type instanceof PluralPersistentAttribute) {
            type = ((PluralPersistentAttribute)type).getElementType();
        }
        if ((newType = QueryHelper.highestPrecedenceType(new SqmExpressable[]{oldType = this.getNodeType(), type})) != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return null;
    }

    @Override
    public boolean allowMultiValuedBinding() {
        return this.canBeMultiValued;
    }

    @Override
    public AllowableParameterType<T> getNodeType() {
        return (AllowableParameterType)super.getNodeType();
    }

    @Override
    public AllowableParameterType<T> getAnticipatedType() {
        return this.getNodeType();
    }

    public Class<T> getParameterType() {
        return this.getNodeType().getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }
}

