/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.internal.QueryLiteralHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmLiteral<T>
extends AbstractSqmExpression<T>
implements DomainResultProducer<T> {
    private final T value;

    public SqmLiteral(T value, SqmExpressable<T> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        assert (value != null);
        this.value = value;
    }

    protected SqmLiteral(SqmExpressable<T> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.value = null;
    }

    public T getLiteralValue() {
        return this.value;
    }

    public <R> R accept(SemanticQueryWalker<R> walker) {
        return walker.visitLiteral(this);
    }

    @Override
    public String asLoggableText() {
        return "Literal( " + this.value + ")";
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        SqmLiteral.appendHqlString(sb, this.getJavaTypeDescriptor(), this.value);
    }

    public static <T> void appendHqlString(StringBuilder sb, JavaType<T> javaTypeDescriptor, T value) {
        String string = javaTypeDescriptor.toString(value);
        if (javaTypeDescriptor.getJavaTypeClass() == String.class) {
            QueryLiteralHelper.appendStringLiteral(sb, string);
        } else {
            sb.append(string);
        }
    }
}

