/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Arrays;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmTuple<T>
extends AbstractSqmExpression<T>
implements JpaCompoundSelection<T> {
    private final List<SqmExpression<?>> groupedExpressions;

    public SqmTuple(NodeBuilder nodeBuilder, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), nodeBuilder);
    }

    public SqmTuple(NodeBuilder nodeBuilder, SqmExpressable<T> type, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), type, nodeBuilder);
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, NodeBuilder nodeBuilder) {
        this(groupedExpressions, null, nodeBuilder);
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, SqmExpressable<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        if (groupedExpressions.isEmpty()) {
            throw new QueryException("tuple grouping cannot be constructed over zero expressions");
        }
        this.groupedExpressions = groupedExpressions;
        if (type == null) {
            this.setExpressableType(nodeBuilder.getTypeConfiguration().resolveTupleType(groupedExpressions));
        }
    }

    public List<SqmExpression<?>> getGroupedExpressions() {
        return this.groupedExpressions;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTuple(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append('(');
        this.groupedExpressions.get(0).appendHqlString(sb);
        for (int i = 1; i < this.groupedExpressions.size(); ++i) {
            sb.append(", ");
            this.groupedExpressions.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }

    @Override
    public String asLoggableText() {
        return this.toString();
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return this.getGroupedExpressions();
    }
}

