/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmUnaryOperation<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final UnaryArithmeticOperator operation;
    private final SqmExpression operand;

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression<T> operand) {
        this(operation, operand, operand.getNodeType());
    }

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression<T> operand, SqmExpressable<T> inherentType) {
        super(inherentType, operand.nodeBuilder());
        this.operation = operation;
        this.operand = operand;
    }

    public SqmExpression getOperand() {
        return this.operand;
    }

    public UnaryArithmeticOperator getOperation() {
        return this.operation;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitUnaryOperationExpression(this);
    }

    @Override
    public String asLoggableText() {
        return (this.operation == UnaryArithmeticOperator.UNARY_MINUS ? (char)'-' : '+') + this.operand.asLoggableText();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.operation == UnaryArithmeticOperator.UNARY_MINUS ? (char)'-' : '+');
        this.operand.appendHqlString(sb);
    }
}

